"use strict";async function cleanupCorruptedOrders(e=!1,r=1e4){const t={totalScanned:0,corruptedFound:0,deleted:0,errors:0};try{console_1.logger.info("CLEANUP",`Starting corrupted orders cleanup (dryRun: ${e}, limit: ${r})`);const o=`\n      SELECT "userId", "createdAt", id, symbol, amount, price, cost, side, status\n      FROM ${client_1.scyllaKeyspace}.orders\n      LIMIT ?\n      ALLOW FILTERING;\n    `,n=await client_1.default.execute(o,[r],{prepare:!0});t.totalScanned=n.rows.length;console_1.logger.info("CLEANUP",`Scanned ${t.totalScanned} orders`);const l=[];for(const e of n.rows){if(null===e.symbol||null===e.amount||null===e.price||null===e.cost||null===e.side){t.corruptedFound++;l.push({userId:e.userId,createdAt:e.createdAt,id:e.id});l.length%100==0&&console_1.logger.info("CLEANUP",`Found ${l.length} corrupted orders so far...`)}}console_1.logger.info("CLEANUP",`Found ${t.corruptedFound} corrupted orders out of ${t.totalScanned} scanned`);if(e){console_1.logger.info("CLEANUP","Dry run mode - no records will be deleted");return t}if(l.length>0){console_1.logger.info("CLEANUP",`Deleting ${l.length} corrupted orders...`);for(const e of l)try{const r=`\n            DELETE FROM ${client_1.scyllaKeyspace}.orders\n            WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n          `;await client_1.default.execute(r,[e.userId,e.createdAt,e.id],{prepare:!0});t.deleted++;t.deleted%100==0&&console_1.logger.info("CLEANUP",`Deleted ${t.deleted} / ${l.length} corrupted orders`)}catch(e){t.errors++;console_1.logger.error("CLEANUP",`Failed to delete order: ${e instanceof Error?e.message:String(e)}`)}}console_1.logger.info("CLEANUP",`Cleanup complete: scanned=${t.totalScanned}, found=${t.corruptedFound}, deleted=${t.deleted}, errors=${t.errors}`);return t}catch(e){console_1.logger.error("CLEANUP",`Cleanup failed: ${e instanceof Error?e.message:String(e)}`,e);throw e}}async function findProblematicOrders(e,r=100){var t;try{if("null-fields"===e){const e=`\n        SELECT "userId", "createdAt", id, symbol, amount, price, cost, side, status\n        FROM ${client_1.scyllaKeyspace}.orders\n        LIMIT ?\n        ALLOW FILTERING;\n      `;return(await client_1.default.execute(e,[10*r],{prepare:!0})).rows.filter(e=>null===e.symbol||null===e.amount||null===e.price||null===e.cost||null===e.side).slice(0,r)}{const e=`\n        SELECT id\n        FROM ${client_1.scyllaKeyspace}.orders\n        LIMIT ?\n        ALLOW FILTERING;\n      `,o=await client_1.default.execute(e,[10*r],{prepare:!0}),n=new Map;for(const e of o.rows){const r=null===(t=e.id)||void 0===t?void 0:t.toString();r&&n.set(r,(n.get(r)||0)+1)}const l=Array.from(n.entries()).filter(([,e])=>e>1).map(([e])=>e).slice(0,r),a=[];for(const e of l){const r=`\n          SELECT *\n          FROM ${client_1.scyllaKeyspace}.orders\n          WHERE id = ?\n          ALLOW FILTERING;\n        `,t=await client_1.default.execute(r,[e],{prepare:!0});a.push(...t.rows)}return a}}catch(e){console_1.logger.error("CLEANUP",`Failed to find problematic orders: ${e instanceof Error?e.message:String(e)}`,e);throw e}}async function getOrderDataQualityStats(){var e;try{const r=`SELECT COUNT(*) as total FROM ${client_1.scyllaKeyspace}.orders;`,t=await client_1.default.execute(r),o=Number((null===(e=t.rows[0])||void 0===e?void 0:e.total)||0),n=Math.min(1e4,o),l=await cleanupCorruptedOrders(!0,n),a=o>0?l.corruptedFound/l.totalScanned*100:0;return{totalOrders:o,corruptedOrders:Math.round(a/100*o),corruptionRate:Number(a.toFixed(2))}}catch(e){console_1.logger.error("CLEANUP",`Failed to get data quality stats: ${e instanceof Error?e.message:String(e)}`,e);throw e}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,r,t,o){void 0===o&&(o=t);var n=Object.getOwnPropertyDescriptor(r,t);n&&!("get"in n?!r.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return r[t]}});Object.defineProperty(e,o,n)}:function(e,r,t,o){void 0===o&&(o=t);e[o]=r[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,r){Object.defineProperty(e,"default",{enumerable:!0,value:r})}:function(e,r){e.default=r}),__importStar=this&&this.__importStar||function(){var e=function(r){e=Object.getOwnPropertyNames||function(e){var r=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[r.length]=t);return r};return e(r)};return function(r){if(r&&r.__esModule)return r;var t={};if(null!=r)for(var o=e(r),n=0;n<o.length;n++)"default"!==o[n]&&__createBinding(t,r,o[n]);__setModuleDefault(t,r);return t}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.cleanupCorruptedOrders=cleanupCorruptedOrders;exports.findProblematicOrders=findProblematicOrders;exports.getOrderDataQualityStats=getOrderDataQualityStats;const client_1=__importStar(require("./client")),console_1=require("@b/utils/console");