"use strict";async function getAiMarketMakerSymbols(e=!1){const r=Date.now();if(!e&&aiMarketMakerSymbolsCache.size>0&&r-aiMarketMakerCacheLastRefresh<6e4)return aiMarketMakerSymbolsCache;try{const{models:e}=await Promise.resolve().then(()=>__importStar(require("@b/db"))),t=await e.aiMarketMaker.findAll({where:{status:"ACTIVE"},include:[{model:e.ecosystemMarket,as:"market",attributes:["currency","pair"]}]}),o=new Set;for(const e of t)if(e.market){const r=`${e.market.currency}/${e.market.pair}`;o.add(r)}aiMarketMakerSymbolsCache=o;aiMarketMakerCacheLastRefresh=r;o.size>0&&console_1.logger.info("ECO_ENGINE",`Found ${o.size} AI market maker symbols: ${Array.from(o).join(", ")}`);return o}catch(e){console_1.logger.error("ECO_ENGINE","Failed to get AI market maker symbols",e);return new Set}}function uuidToString(e){try{if("string"==typeof e)return e;if(e&&"function"==typeof e.toString)return e.toString();if(null==e?void 0:e.buffer)return(0,uuid_1.stringify)(e.buffer);throw(0,error_1.createError)({statusCode:400,message:"Invalid UUID format"})}catch(e){return"00000000-0000-0000-0000-000000000000"}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,r,t,o){void 0===o&&(o=t);var i=Object.getOwnPropertyDescriptor(r,t);i&&!("get"in i?!r.__esModule:i.writable||i.configurable)||(i={enumerable:!0,get:function(){return r[t]}});Object.defineProperty(e,o,i)}:function(e,r,t,o){void 0===o&&(o=t);e[o]=r[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,r){Object.defineProperty(e,"default",{enumerable:!0,value:r})}:function(e,r){e.default=r}),__importStar=this&&this.__importStar||function(){var e=function(r){e=Object.getOwnPropertyNames||function(e){var r=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[r.length]=t);return r};return e(r)};return function(r){if(r&&r.__esModule)return r;var t={};if(null!=r)for(var o=e(r),i=0;i<o.length;i++)"default"!==o[i]&&__createBinding(t,r,o[i]);__setModuleDefault(t,r);return t}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.MatchingEngine=void 0;const blockchain_1=require("./blockchain"),candles_1=require("./candles"),matchmaking_1=require("./matchmaking"),orderbook_1=require("./orderbook"),client_1=__importStar(require("./scylla/client")),queries_1=require("./scylla/queries"),ws_1=require("./ws"),markets_1=require("./markets"),console_1=require("@b/utils/console"),uuid_1=require("uuid"),error_1=require("@b/utils/error");let aiMarketMakerSymbolsCache=new Set,aiMarketMakerCacheLastRefresh=0;const AI_MARKET_MAKER_CACHE_TTL=6e4;class MatchingEngine{constructor(){this.orderQueue={};this.marketsBySymbol={};this.lockedOrders=new Set;this.lastCandle={};this.yesterdayCandle={}}static getInstance(){this.instancePromise||(this.instancePromise=(async()=>{const e=new MatchingEngine;await e.init();return e})());return this.instancePromise}async init(){await this.initializeMarkets();await this.initializeOrders();await this.initializeLastCandles();await this.initializeYesterdayCandles()}async initializeMarkets(){(await(0,markets_1.getEcoSystemMarkets)()).forEach(e=>{this.marketsBySymbol[e.symbol]=e;this.orderQueue[e.symbol]=[]})}async initializeOrders(){try{(await(0,queries_1.getAllOpenOrders)()).forEach(e=>{var r,t,o,i,a,s,n,l;const c=new Date(e.createdAt),d=new Date(e.updatedAt);if(isNaN(c.getTime())||isNaN(d.getTime())){console_1.logger.error("ECO_ENGINE","Invalid date in order",new Error("Invalid date in order"));return}if(!(null===(r=e.userId)||void 0===r?void 0:r.buffer)||!(null===(t=e.id)||void 0===t?void 0:t.buffer)){console_1.logger.error("ECO_ENGINE","Invalid Uuid in order",new Error("Invalid Uuid in order"));return}const u=uuidToString(e.userId),h=uuidToString(e.id);if("00000000-0000-0000-0000-000000000000"===u)return;const g=e.marketMakerId?uuidToString(e.marketMakerId):void 0,m=e.botId?uuidToString(e.botId):void 0,f={...e,amount:BigInt(null!==(o=e.amount)&&void 0!==o?o:0),price:BigInt(null!==(i=e.price)&&void 0!==i?i:0),cost:BigInt(null!==(a=e.cost)&&void 0!==a?a:0),fee:BigInt(null!==(s=e.fee)&&void 0!==s?s:0),remaining:BigInt(null!==(n=e.remaining)&&void 0!==n?n:0),filled:BigInt(null!==(l=e.filled)&&void 0!==l?l:0),createdAt:c,updatedAt:d,userId:u,id:h,marketMakerId:"00000000-0000-0000-0000-000000000000"!==g?g:void 0,botId:"00000000-0000-0000-0000-000000000000"!==m?m:void 0};this.orderQueue[f.symbol]||(this.orderQueue[f.symbol]=[]);this.orderQueue[f.symbol].push(f)});await this.processQueue()}catch(e){console_1.logger.error("ECO_ENGINE","Failed to populate order queue with open orders",e)}}async syncOrderbookWithOrders(){var e;try{const r=await getAiMarketMakerSymbols(!0),t=await(0,queries_1.fetchOrderBooks)();if(!t||0===t.length)return;const o={};t.forEach(e=>{o[e.symbol]||(o[e.symbol]=[]);o[e.symbol].push(e)});let i=0;for(const t in o){if(r.has(t))continue;const a=o[t],s=this.orderQueue[t]||[],n={};for(const e of s){const r=(0,blockchain_1.fromBigInt)(e.price).toString();n[r]||(n[r]={bids:BigInt(0),asks:BigInt(0)});"BUY"===e.side?n[r].bids+=e.remaining:n[r].asks+=e.remaining}for(const r of a){const o=r.price.toString(),a=r.side.toUpperCase(),s=(0,blockchain_1.toBigIntFloat)(Number(r.amount)),l=(null===(e=n[o])||void 0===e?void 0:e["BIDS"===a?"bids":"asks"])||BigInt(0);if(s!==l)if(l===BigInt(0))try{const e=`DELETE FROM ${client_1.scyllaKeyspace}.orderbook WHERE symbol = ? AND price = ? AND side = ?`;await client_1.default.execute(e,[t,o,a],{prepare:!0});i++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to remove ghost entry for ${t}: ${e.message}`)}else try{const e=`UPDATE ${client_1.scyllaKeyspace}.orderbook SET amount = ? WHERE symbol = ? AND price = ? AND side = ?`;await client_1.default.execute(e,[(0,blockchain_1.fromBigInt)(l),t,o,a],{prepare:!0});i++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to fix amount for ${t}: ${e.message}`)}}for(const e in n){const r=n[e];if(r.bids>BigInt(0)){if(!a.find(r=>r.price.toString()===e&&"BIDS"===r.side.toUpperCase()))try{const o=`INSERT INTO ${client_1.scyllaKeyspace}.orderbook (symbol, price, side, amount) VALUES (?, ?, ?, ?)`;await client_1.default.execute(o,[t,e,"BIDS",(0,blockchain_1.fromBigInt)(r.bids)],{prepare:!0});i++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to add missing BID entry for ${t}: ${e.message}`)}}if(r.asks>BigInt(0)){if(!a.find(r=>r.price.toString()===e&&"ASKS"===r.side.toUpperCase()))try{const o=`INSERT INTO ${client_1.scyllaKeyspace}.orderbook (symbol, price, side, amount) VALUES (?, ?, ?, ?)`;await client_1.default.execute(o,[t,e,"ASKS",(0,blockchain_1.fromBigInt)(r.asks)],{prepare:!0});i++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to add missing ASK entry for ${t}: ${e.message}`)}}}}if(i>0){console_1.logger.info("ECO_ENGINE",`Fixed ${i} orderbook discrepancies`);await this.refreshOrderBooks()}}catch(e){console_1.logger.error("ECO_ENGINE","Orderbook sync failed",e)}}async validateAndCleanOrderbook(){var e,r,t,o;try{await this.syncOrderbookWithOrders();const{getUserEcosystemWalletByCurrency:i}=await Promise.resolve().then(()=>__importStar(require("./matchmaking"))),{updateWalletBalance:a}=await Promise.resolve().then(()=>__importStar(require("./wallet")));let s=0,n=0,l=0;for(const c in this.orderQueue){if(!c||"undefined"===c||!c.includes("/"))continue;const d=this.orderQueue[c],[u,h]=c.split("/"),g=[];for(const l of d){s++;try{if(l.marketMakerId)continue;const s=(0,blockchain_1.fromBigInt)((0,blockchain_1.removeTolerance)(l.remaining)),d=Number(l.remaining)/Number(l.amount),m=(0,blockchain_1.fromBigInt)((0,blockchain_1.removeTolerance)(l.cost))*d;if("SELL"===l.side){const t=await i(l.userId,u);if(!t){console_1.logger.warn("ECO_ENGINE",`Wallet not found for user ${l.userId}, currency ${u}`);g.push(l);continue}const o=parseFloat((null===(e=t.inOrder)||void 0===e?void 0:e.toString())||"0"),d=parseFloat((null===(r=t.balance)||void 0===r?void 0:r.toString())||"0");if(o<s){if(d-o>=s)try{const e=`eco_order_lock_${l.id}_${t.id}`;await a(t,s,"subtract",e);n++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to lock funds for ${c}: ${e.message}`);g.push(l)}else g.push(l)}}else if("BUY"===l.side){const e=await i(l.userId,h);if(!e){console_1.logger.warn("ECO_ENGINE",`Wallet not found for user ${l.userId}, currency ${h}`);g.push(l);continue}const r=parseFloat((null===(t=e.inOrder)||void 0===t?void 0:t.toString())||"0"),s=parseFloat((null===(o=e.balance)||void 0===o?void 0:o.toString())||"0");if(r<m){if(s-r>=m)try{const r=`eco_order_lock_${l.id}_${e.id}`;await a(e,m,"subtract",r);n++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to lock funds for ${c}: ${e.message}`);g.push(l)}else g.push(l)}}}catch(e){console_1.logger.error("ECO_ENGINE",`Error validating order ${l.id}: ${e.message}`);g.push(l)}}if(g.length>0)for(const e of g)try{const{cancelOrderByUuid:r}=await Promise.resolve().then(()=>__importStar(require("./scylla/queries")));await r(e.userId,e.id,e.createdAt.toISOString(),e.symbol,e.price,e.side,e.remaining);const t=this.orderQueue[c].indexOf(e);t>-1&&this.orderQueue[c].splice(t,1);await(0,ws_1.handleOrderBroadcast)({...e,status:"CANCELLED"});l++}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to cancel order for ${c}: ${e.message}`)}}(n>0||l>0)&&console_1.logger.info("ECO_ENGINE",`Fixed ${n} orders, cancelled ${l} invalid orders`);if(n>0||l>0){await this.refreshOrderBooks();if(n>0){for(const e in this.orderQueue)this.orderQueue[e]=[];const e=await(0,queries_1.getAllOpenOrders)(),r=await Promise.resolve().then(()=>__importStar(require("uuid"))).then(e=>e.stringify);e.forEach(e=>{var t,o,i,a,s,n,l,c;const d=new Date(e.createdAt),u=new Date(e.updatedAt);if(isNaN(d.getTime())||isNaN(u.getTime()))return;if(!(null===(t=e.userId)||void 0===t?void 0:t.buffer)||!(null===(o=e.id)||void 0===o?void 0:o.buffer))return;const h={...e,amount:BigInt(null!==(i=e.amount)&&void 0!==i?i:0),price:BigInt(null!==(a=e.price)&&void 0!==a?a:0),cost:BigInt(null!==(s=e.cost)&&void 0!==s?s:0),fee:BigInt(null!==(n=e.fee)&&void 0!==n?n:0),remaining:BigInt(null!==(l=e.remaining)&&void 0!==l?l:0),filled:BigInt(null!==(c=e.filled)&&void 0!==c?c:0),createdAt:d,updatedAt:u,userId:r(e.userId.buffer),id:r(e.id.buffer)};this.orderQueue[h.symbol]||(this.orderQueue[h.symbol]=[]);this.orderQueue[h.symbol].push(h)});await this.processQueue()}}}catch(e){console_1.logger.error("ECO_ENGINE","Orderbook validation failed",e)}}async refreshOrderBooks(){try{const e=await(0,queries_1.fetchOrderBooks)(),r={};null==e||e.forEach(e=>{r[e.symbol]||(r[e.symbol]={bids:{},asks:{}});r[e.symbol][e.side.toLowerCase()][(0,blockchain_1.removeTolerance)((0,blockchain_1.toBigIntFloat)(Number(e.price))).toString()]=(0,blockchain_1.removeTolerance)((0,blockchain_1.toBigIntFloat)(Number(e.amount)))});for(const e in r)await(0,ws_1.handleOrderBookBroadcast)(e,r[e])}catch(e){console_1.logger.error("ECO_ENGINE",`Failed to refresh orderbooks: ${e}`)}}async initializeLastCandles(){try{(await(0,queries_1.getLastCandles)()).forEach(e=>{this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});this.lastCandle[e.symbol][e.interval]=e})}catch(e){console_1.logger.error("ECO_ENGINE","Failed to initialize last candles",e)}}async initializeYesterdayCandles(){try{const e=await(0,queries_1.getYesterdayCandles)();Object.keys(e).forEach(r=>{const t=e[r];t.length>0&&(this.yesterdayCandle[r]=t[0])})}catch(e){console_1.logger.error("ECO_ENGINE","Failed to initialize yesterday's candles",e)}}async processQueue(){const e=[],r={},t=await(0,queries_1.fetchOrderBooks)(),o={};null==t||t.forEach(e=>{o[e.symbol]||(o[e.symbol]={bids:{},asks:{}});o[e.symbol][e.side.toLowerCase()][(0,blockchain_1.removeTolerance)((0,blockchain_1.toBigIntFloat)(Number(e.price))).toString()]=(0,blockchain_1.removeTolerance)((0,blockchain_1.toBigIntFloat)(Number(e.amount)))});const i=[];for(const t in this.orderQueue){const a=this.orderQueue[t];if(0===a.length)continue;const s=(async()=>{const{matchedOrders:i,bookUpdates:s}=await(0,matchmaking_1.matchAndCalculateOrders)(a,o[t]||{bids:{},asks:{}});if(0!==i.length){e.push(...i);r[t]=s}})();i.push(s)}await Promise.all(i);if(0===e.length)return;await this.performUpdates(e,r);const a={};for(const e in r){const t=o[e]||{bids:{},asks:{}};a[e]=(0,orderbook_1.applyUpdatesToOrderBook)(t,r[e])}const s=[];for(const e in this.orderQueue){const r=(async()=>{this.orderQueue[e]=this.orderQueue[e].filter(e=>"OPEN"===e.status)})();s.push(r)}await Promise.all(s);this.broadcastUpdates(e,a)}async performUpdates(e,r){if(!this.lockOrders(e)){console_1.logger.warn("ECO_ENGINE","Couldn't obtain a lock on all orders, skipping this batch.");return}const t=[],o=await(0,queries_1.generateOrderUpdateQueries)(e);t.push(...o);const i=(0,candles_1.getLatestOrdersForCandles)(e);for(const e of i){const r=await this.updateLastCandles(e);t.push(...r)}const a=(0,orderbook_1.generateOrderBookUpdateQueries)(r);t.push(...a);if(t.length>0)try{await client_1.default.batch(t,{prepare:!0})}catch(e){console_1.logger.error("ECO_ENGINE","Failed to batch update",e)}else console_1.logger.warn("ECO_ENGINE","No queries to batch update.");this.unlockOrders(e)}async addToQueue(e){if(!(0,matchmaking_1.validateOrder)(e))return;if(!e.createdAt||isNaN(new Date(e.createdAt).getTime())||!e.updatedAt||isNaN(new Date(e.updatedAt).getTime())){console_1.logger.error("ECO_ENGINE","Invalid date in order",new Error("Invalid date in order"));return}this.orderQueue[e.symbol]||(this.orderQueue[e.symbol]=[]);this.orderQueue[e.symbol].push(e);const r=await(0,orderbook_1.updateSingleOrderBook)(e,"add");(0,ws_1.handleOrderBookBroadcast)(e.symbol,r);await this.processQueue()}async updateLastCandles(e){let r,t=BigInt(0);try{r=JSON.parse(e.trades)}catch(e){console_1.logger.error("ECO_ENGINE","Failed to parse trades",e);return[]}if(r&&r.length>0&&void 0!==r[r.length-1].price)t=(0,blockchain_1.toBigIntFloat)(r[r.length-1].price);else{if(void 0===e.price){console_1.logger.error("ECO_ENGINE","Neither trade prices nor order price are available",new Error("Neither trade prices nor order price are available"));return[]}t=e.price}const o=[];this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});for(const r of candles_1.intervals){const i=await this.generateCandleQueries(e,r,t);i&&o.push(i)}return o}async generateCandleQueries(e,r,t){var o;let i=null===(o=this.lastCandle[e.symbol])||void 0===o?void 0:o[r];const a=(0,ws_1.normalizeTimeToInterval)((new Date).getTime(),r),s=i?(0,ws_1.normalizeTimeToInterval)(new Date(i.createdAt).getTime(),r):null;if(!i||a!==s){let o;if(i)o=i.close;else{const i=await(0,queries_1.getLatestCandleForSymbol)(e.symbol,r);if(i){o=i.close;this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});this.lastCandle[e.symbol][r]=i}else o=(0,blockchain_1.fromBigInt)(t)}if(!o&&0!==o)return null;const a=(0,blockchain_1.fromBigInt)(t),s=new Date((0,ws_1.normalizeTimeToInterval)((new Date).getTime(),r)),n={symbol:e.symbol,interval:r,open:o,high:Math.max(o,a),low:Math.min(o,a),close:a,volume:(0,blockchain_1.fromBigInt)(e.amount),createdAt:s,updatedAt:new Date};this.lastCandle[e.symbol]||(this.lastCandle[e.symbol]={});this.lastCandle[e.symbol][r]=n;return{query:'INSERT INTO candles (symbol, interval, "createdAt", "updatedAt", open, high, low, close, volume) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)',params:[e.symbol,r,n.createdAt,n.updatedAt,o,n.high,n.low,n.close,n.volume]}}{let o='UPDATE candles SET "updatedAt" = ?, close = ?';const a=new Date,s=(0,blockchain_1.fromBigInt)(t),n=[a,s],l=i.volume+(0,blockchain_1.fromBigInt)(e.amount);o+=", volume = ?";n.push(l);if(s>i.high){o+=", high = ?";n.push(s);i.high=s}else if(s<i.low){o+=", low = ?";n.push(s);i.low=s}i.close=s;i.volume=l;i.updatedAt=a;this.lastCandle[e.symbol][r]=i;o+=' WHERE symbol = ? AND interval = ? AND "createdAt" = ?';n.push(e.symbol,r,i.createdAt);return{query:o,params:n}}}async broadcastUpdates(e,r){const t=[];t.push(...this.createOrdersBroadcastPromise(e));for(const e in r){t.push(this.createOrderBookUpdatePromise(e,r[e]));t.push(...this.createCandleBroadcastPromises(e))}await Promise.all(t)}createOrderBookUpdatePromise(e,r){return(0,ws_1.handleOrderBookBroadcast)(e,r)}createCandleBroadcastPromises(e){const r=[];if(this.lastCandle[e])for(const t in this.lastCandle[e])r.push((0,ws_1.handleCandleBroadcast)(e,t,this.lastCandle[e][t]));r.push((0,ws_1.handleTickerBroadcast)(e,this.getTicker(e)),(0,ws_1.handleTickersBroadcast)(this.getTickers()));return r}createOrdersBroadcastPromise(e){return e.map(e=>(0,ws_1.handleOrderBroadcast)(e))}lockOrders(e){for(const r of e)if(this.lockedOrders.has(r.id))return!1;for(const r of e)this.lockedOrders.add(r.id);return!0}unlockOrders(e){for(const r of e)this.lockedOrders.delete(r.id)}async handleOrderCancellation(e,r){this.orderQueue[r]=this.orderQueue[r].filter(r=>r.id!==e);const t=await(0,orderbook_1.fetchExistingAmounts)(r);(0,ws_1.handleOrderBookBroadcast)(r,t);await this.processQueue()}getTickers(){const e={};for(const r in this.lastCandle){const t=this.getTicker(r);0!==t.last&&(e[r]=t)}return e}getTicker(e){var r;const t=null===(r=this.lastCandle[e])||void 0===r?void 0:r["1d"],o=this.yesterdayCandle[e];if(!t)return{symbol:e,last:0,baseVolume:0,quoteVolume:0,change:0,percentage:0,high:0,low:0};const i=t.close,a=t.volume,s=i*a;let n=0,l=0;if(o){const e=o.close,r=t.close;n=r-e;l=(r-e)/e*100}return{symbol:e,last:i,baseVolume:a,quoteVolume:s,percentage:l,change:n,high:t.high,low:t.low}}}exports.MatchingEngine=MatchingEngine;MatchingEngine.instancePromise=null;