"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Retrieves all ecosystem tokens",description:"Fetches a list of all active tokens available in the ecosystem.",operationId:"listEcosystemTokens",tags:["Ecosystem","Tokens"],logModule:"ECOSYSTEM",logTitle:"List ecosystem tokens",responses:{200:{description:"Tokens retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseTokenSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Token"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:t}=e;try{null==t||t.step("Fetching active ecosystem tokens");const e=await db_1.models.ecosystemToken.findAll({where:{status:!0},attributes:["name","currency","chain","type","status","precision","limits","decimals","icon","contractType","network","fee"]});null==t||t.success(`Retrieved ${(null==e?void 0:e.length)||0} active tokens`);return e}catch(e){null==t||t.fail(`Failed to fetch tokens: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch tokens: ${e.message}`})}};