"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.MODeposits=void 0;const ethers_1=require("ethers"),ProviderManager_1=require("../ProviderManager"),tokens_1=require("@b/api/(ext)/ecosystem/utils/tokens"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),DepositUtils_1=require("../DepositUtils"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class MODeposits{constructor(t){this.intervalId=null;this.stopOnFirstDeposit=!0;this.pollingIntervalMs=1e4;this.maxBlocksPerPoll=5e3;this.backoffAttempts=0;this.maxBackoffAttempts=5;this.wallet=t.wallet;this.chain=t.chain;this.currency=t.currency;this.address=t.address;this.contractType=t.contractType}async watchDeposits(){let t=ProviderManager_1.chainProviders.get(this.chain);if(!t){t=await(0,ProviderManager_1.initializeHttpProvider)(this.chain);if(!t)throw(0,error_1.createError)({statusCode:503,message:`Failed to initialize HTTP provider for chain ${this.chain}`})}console_1.logger.info("MO_DEPOSIT",`Using polling for ${this.chain} ERC-20 deposits on address ${this.address}`);const e=await(0,tokens_1.getEcosystemToken)(this.chain,this.currency);if(!e)throw(0,error_1.createError)({statusCode:404,message:`Token ${this.currency} not found for chain ${this.chain}`});const s=e.decimals,i={address:e.contract,topics:[ethers_1.ethers.id("Transfer(address,address,uint256)"),null,ethers_1.ethers.zeroPadValue(this.address,32)]};await this.pollForEvents(t,i,s)}async pollForEvents(t,e,s){const i=`${this.chain}:${this.address}`;let o;try{o=await t.getBlockNumber()}catch(t){console_1.logger.error("MO_DEPOSIT",`Failed to get initial block number for ${i}`,t);throw t}this.intervalId=setInterval(async()=>{try{const r=await t.getBlockNumber();if(r>o){const n=o+1,a=Math.min(r,n+this.maxBlocksPerPoll-1);console_1.logger.debug("MO_DEPOSIT",`Polling ${i} from block ${n} to ${a}`);const l=await t.getLogs({...e,fromBlock:n,toBlock:a});this.backoffAttempts=0;for(const e of l){console_1.logger.info("MO_DEPOSIT",`New event detected on ${i}: TxHash=${e.transactionHash}`);if(await(0,DepositUtils_1.processTransaction)(this.contractType,e.transactionHash,t,this.address,this.chain,s,chains_1.chainConfigs[this.chain].decimals,this.wallet.id)){console_1.logger.success("MO_DEPOSIT",`Deposit recorded for ${i}.`);if(this.stopOnFirstDeposit){console_1.logger.info("MO_DEPOSIT",`Stop on first deposit enabled. Stopping polling for ${i}`);this.stopPolling();return}}}o=a}}catch(o){console_1.logger.error("MO_DEPOSIT",`Error during event polling for ${i}`,o);this.backoffAttempts++;if(this.backoffAttempts>this.maxBackoffAttempts){console_1.logger.error("MO_DEPOSIT",`Max backoff attempts reached for ${i}. Stopping polling.`);this.stopPolling();return}const r=this.pollingIntervalMs*Math.pow(2,this.backoffAttempts);console_1.logger.warn("MO_DEPOSIT",`Backing off polling for ${i}. Next poll in ${r}ms`);if(this.intervalId){clearInterval(this.intervalId);this.intervalId=null}setTimeout(()=>{this.intervalId=setInterval(()=>this.pollForEvents(t,e,s),this.pollingIntervalMs)},r)}},this.pollingIntervalMs)}stopPolling(){if(this.intervalId){console_1.logger.info("MO_DEPOSIT",`Stopping polling for ${this.chain}:${this.address}`);clearInterval(this.intervalId);this.intervalId=null}}}exports.MODeposits=MODeposits;