"use strict";async function verifyPendingTransactions(){if(!(0,Websocket_1.hasClients)("/api/ecosystem/deposit"))return;const e=new Set,t={total:0,processed:0,failed:0,skipped:0};try{const o=await(0,deposit_1.loadFromRedis)("pendingTransactions");if(!o||0===Object.keys(o).length)return;const i=Object.keys(o);t.total=i.length;console_1.logger.info("DEPOSIT",`Starting verification of ${i.length} pending transactions`);const s=5,r=[];for(let e=0;e<i.length;e+=s)r.push(i.slice(e,e+s));for(const i of r){const s=i.map(async i=>{var s,r,n,a,c,l,d,f,g,p;if(e.has(i)){console_1.logger.debug("DEPOSIT",`Transaction ${i} already being processed, skipping`);t.skipped++}else try{const p=o[i];if(!p){console_1.logger.error("DEPOSIT",`Transaction ${i} not found in pending list`);t.failed++;return}const u=`${i}:${p.chain}`,T=verificationAttempts.get(u)||0;if(T>=MAX_VERIFICATION_ATTEMPTS){console_1.logger.warn("DEPOSIT",`Max verification attempts reached for ${i}, removing from pending`);delete o[i];verificationAttempts.delete(u);await(0,deposit_1.offloadToRedis)("pendingTransactions",o);t.failed++;return}e.add(i);const m=p.chain;let v=!1,_=null;if(["SOL","TRON","XMR","TON"].includes(m)){v="COMPLETED"===p.status||"CONFIRMED"===p.status;_=p;v&&console_1.logger.success("DEPOSIT",`${m} transaction ${i} already confirmed`)}else if(["BTC","LTC","DOGE","DASH"].includes(m))try{const e=await(0,utxo_1.verifyUTXOTransaction)(m,i);v=e.confirmed;_={...p,status:v?"COMPLETED":"PENDING",fee:e.fee||0};v?console_1.logger.success("DEPOSIT",`UTXO transaction ${i} confirmed`):console_1.logger.debug("DEPOSIT",`UTXO transaction ${i} still pending confirmation`)}catch(e){console_1.logger.error("DEPOSIT",`UTXO verification failed for ${i}: ${e.message}`);verificationAttempts.set(u,T+1);t.failed++;return}else{let e=ProviderManager_1.chainProviders.get(m);if(!e){e=await(0,ProviderManager_1.initializeWebSocketProvider)(m);e||(e=await(0,ProviderManager_1.initializeHttpProvider)(m))}if(!e){console_1.logger.error("DEPOSIT",`Provider not available for chain ${m}`);verificationAttempts.set(u,T+1);t.failed++;return}try{const t=await e.getTransactionReceipt(i);if(!t){console_1.logger.debug("DEPOSIT",`Transaction ${i} on ${m} not yet confirmed`);verificationAttempts.set(u,T+1);return}v=1===t.status;_={...p,gasUsed:(null===(s=t.gasUsed)||void 0===s?void 0:s.toString())||"0",effectiveGasPrice:(null===(r=t.effectiveGasPrice)||void 0===r?void 0:r.toString())||p.gasPrice||"0",blockNumber:(null===(n=t.blockNumber)||void 0===n?void 0:n.toString())||"0",status:v?"COMPLETED":"FAILED"};v?console_1.logger.success("DEPOSIT",`EVM transaction ${i} on ${m} confirmed in block ${t.blockNumber}`):console_1.logger.warn("DEPOSIT",`EVM transaction ${i} on ${m} failed`)}catch(e){console_1.logger.error("DEPOSIT",`Error fetching receipt for ${i} on ${m}: ${e.message}`);verificationAttempts.set(u,T+1);t.failed++;return}}if(v&&_)try{console_1.logger.info("DEPOSIT",`Processing confirmed transaction ${i} for deposit handling`);const e=await(0,wallet_1.handleEcosystemDeposit)(_);if(!e.transactionId){console_1.logger.info("DEPOSIT",`Transaction ${i} already processed or invalid, removing from pending`);delete o[i];verificationAttempts.delete(u);await(0,deposit_1.offloadToRedis)("pendingTransactions",o);t.skipped++;return}const s="MO"===m?null===(a=p.to)||void 0===a?void 0:a.toLowerCase():"string"==typeof p.to?p.to:null===(c=p.address)||void 0===c?void 0:c.toLowerCase();try{Websocket_1.messageBroker.broadcastToSubscribedClients("/api/ecosystem/deposit",{currency:null===(l=e.wallet)||void 0===l?void 0:l.currency,chain:m,address:s},{stream:"verification",data:{status:200,message:"Transaction completed",...e,trx:_,balance:null===(d=e.wallet)||void 0===d?void 0:d.balance,currency:null===(f=e.wallet)||void 0===f?void 0:f.currency,chain:m,method:"Wallet Deposit"}});console_1.logger.success("DEPOSIT",`WebSocket broadcast sent for transaction ${i}`)}catch(e){console_1.logger.error("DEPOSIT",`WebSocket broadcast failed for ${i}: ${e.message}`)}if("NO_PERMIT"===p.contractType&&p.to)try{await(0,utils_1.unlockAddress)(p.to);console_1.logger.success("DEPOSIT",`Address ${p.to} unlocked for NO_PERMIT transaction ${i}`)}catch(e){console_1.logger.error("DEPOSIT",`Failed to unlock address ${p.to}: ${e.message}`)}if(null===(g=e.wallet)||void 0===g?void 0:g.userId)try{await(0,notifications_1.createNotification)({userId:e.wallet.userId,relatedId:e.transactionId,title:"Deposit Confirmation",message:`Your deposit of ${_.amount} ${e.wallet.currency} has been confirmed.`,type:"system",link:"/finance/history",actions:[{label:"View Deposit",link:"/finance/history",primary:!0}]});console_1.logger.success("DEPOSIT",`Notification created for user ${e.wallet.userId}`)}catch(e){console_1.logger.error("DEPOSIT",`Failed to create notification: ${e.message}`)}delete o[i];verificationAttempts.delete(u);await(0,deposit_1.offloadToRedis)("pendingTransactions",o);t.processed++;console_1.logger.success("DEPOSIT",`Transaction ${i} fully processed and removed from pending`)}catch(e){console_1.logger.error("DEPOSIT",`Error handling deposit for ${i}: ${e.message}`);if(e.message.includes("already processed")){delete o[i];verificationAttempts.delete(u);await(0,deposit_1.offloadToRedis)("pendingTransactions",o);t.skipped++}else{verificationAttempts.set(u,T+1);t.failed++}}else verificationAttempts.set(u,T+1)}catch(e){console_1.logger.error("DEPOSIT",`Error verifying transaction ${i}: ${e.message}`);const s=`${i}:${(null===(p=o[i])||void 0===p?void 0:p.chain)||"unknown"}`,r=verificationAttempts.get(s)||0;verificationAttempts.set(s,r+1);t.failed++}finally{e.delete(i)}});await Promise.all(s)}console_1.logger.info("DEPOSIT",`Verification completed - Total: ${t.total}, Processed: ${t.processed}, Failed: ${t.failed}, Skipped: ${t.skipped}`)}catch(e){console_1.logger.error("DEPOSIT",`Error in verifyPendingTransactions: ${e.message}`)}finally{cleanupVerificationAttempts()}}function cleanupVerificationAttempts(){const e=Date.now()-18e5;for(const[t,o]of verificationAttempts.entries())o<e&&verificationAttempts.delete(t)}Object.defineProperty(exports,"__esModule",{value:!0});exports.verifyPendingTransactions=verifyPendingTransactions;const deposit_1=require("@b/api/(ext)/ecosystem/utils/redis/deposit"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),Websocket_1=require("@b/handler/Websocket"),utxo_1=require("@b/api/(ext)/ecosystem/utils/utxo"),notifications_1=require("@b/utils/notifications"),utils_1=require("../../wallet/utils"),ProviderManager_1=require("./ProviderManager"),console_1=require("@b/utils/console"),verificationAttempts=new Map,MAX_VERIFICATION_ATTEMPTS=5,VERIFICATION_ATTEMPT_RESET_TIME=18e5;