"use strict";function createMonitor(e,o){const{wallet:t,currency:r,address:n,contractType:i}=o;try{return["BTC","LTC","DOGE","DASH"].includes(e)?new UTXODeposits_1.UTXODeposits({wallet:t,chain:e,address:n}):"SOL"===e?new SolanaDeposits_1.SolanaDeposits({wallet:t,chain:e,currency:r,address:n}):"TRON"===e?new TronDeposits_1.TronDeposits({wallet:t,chain:e,address:n}):"XMR"===e?new MoneroDeposits_1.MoneroDeposits({wallet:t}):"TON"===e?new TonDeposits_1.TonDeposits({wallet:t,chain:e,address:n}):"MO"===e&&"NATIVE"!==i?new MODeposits_1.MODeposits({wallet:t,chain:e,currency:r,address:n,contractType:i}):new EVMDeposits_1.EVMDeposits({wallet:t,chain:e,currency:r,address:n,contractType:i})}catch(o){console_1.logger.error("DEPOSIT_WS",`Error creating monitor for chain ${e}: ${o.message}`);return null}}Object.defineProperty(exports,"__esModule",{value:!0});exports.onClose=exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),tokens_1=require("@b/api/(ext)/ecosystem/utils/tokens"),EVMDeposits_1=require("./util/monitor/EVMDeposits"),UTXODeposits_1=require("./util/monitor/UTXODeposits"),SolanaDeposits_1=require("./util/monitor/SolanaDeposits"),TronDeposits_1=require("./util/monitor/TronDeposits"),MoneroDeposits_1=require("./util/monitor/MoneroDeposits"),TonDeposits_1=require("./util/monitor/TonDeposits"),MODeposits_1=require("./util/monitor/MODeposits"),cron_1=require("@b/cron"),PendingVerification_1=require("./util/PendingVerification"),worker_threads_1=require("worker_threads"),console_1=require("@b/utils/console"),monitorInstances=new Map,monitorStopTimeouts=new Map,activeConnections=new Map;let workerInitialized=!1;exports.metadata={logModule:"ECOSYSTEM",logTitle:"Deposit WebSocket monitoring"};exports.default=async(e,o)=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)(401,"Unauthorized");null==r||r.step("Parsing deposit WebSocket message");if("string"==typeof o)try{o=JSON.parse(o)}catch(e){console_1.logger.error("DEPOSIT_WS",`Failed to parse incoming message: ${e.message}`);null==r||r.fail("Invalid JSON payload");throw(0,error_1.createError)(400,"Invalid JSON payload")}const{currency:n,chain:i,address:s}=o.payload;null==r||r.step("Validating deposit parameters");if(!n||!i){null==r||r.fail("Missing currency or chain");throw(0,error_1.createError)(400,"Currency and chain are required")}try{null==r||r.step(`Finding wallet for ${n}`);const e=await db_1.models.wallet.findOne({where:{userId:t.id,currency:n,type:"ECO"}});if(!e){null==r||r.fail("Wallet not found");throw(0,error_1.createError)(400,"Wallet not found")}if(!e.address){null==r||r.fail("Wallet address not found");throw(0,error_1.createError)(400,"Wallet address not found")}const o=JSON.parse(e.address)[i];if(!o){null==r||r.fail("Address not found for chain");throw(0,error_1.createError)(400,"Address not found")}null==r||r.step(`Fetching token configuration for ${n} on ${i}`);const a=await(0,tokens_1.getEcosystemToken)(i,n);if(!a){null==r||r.fail("Token not found");throw(0,error_1.createError)(400,"Token not found")}const c=a.contractType,l="NO_PERMIT"===c?s:o.address,d=t.id;activeConnections.set(d,{userId:t.id,currency:n,chain:i,address:l,contractType:c,connectedAt:Date.now()});if(monitorStopTimeouts.has(d)){clearTimeout(monitorStopTimeouts.get(d));monitorStopTimeouts.delete(d);console_1.logger.info("DEPOSIT_WS",`Cleared stop timeout for user ${d} on reconnection`)}let u=monitorInstances.get(d);if(u){const e=activeConnections.get(d);if(!1===u.active||e&&(u.chain!==i||u.currency!==n||u.address!==l)){console_1.logger.info("DEPOSIT_WS",`Monitor for user ${d} is stale or inactive. Creating a new monitor.`);"function"==typeof u.stopPolling&&u.stopPolling();monitorInstances.delete(d);u=null}}if(u){console_1.logger.info("DEPOSIT_WS",`Reusing existing monitor for user ${d}`);null==r||r.success(`Reusing existing deposit monitor for ${i}/${n}`)}else{null==r||r.step(`Creating new deposit monitor for ${i}/${n}`);console_1.logger.info("DEPOSIT_WS",`Creating new monitor for user ${d}, chain: ${i}, currency: ${n}`);u=createMonitor(i,{wallet:e,chain:i,currency:n,address:l,contractType:c});if(!u){console_1.logger.error("DEPOSIT_WS",`Failed to create monitor for chain ${i}`);null==r||r.fail(`Monitor creation failed for chain ${i}`);throw(0,error_1.createError)(500,`Monitor creation failed for chain ${i}`)}await u.watchDeposits();monitorInstances.set(d,u);console_1.logger.success("DEPOSIT_WS",`Monitor created and started for user ${d}`);null==r||r.success(`Deposit monitor started for ${i}/${n}`)}if(worker_threads_1.isMainThread&&!workerInitialized)try{null==r||r.step("Initializing verification worker");await(0,cron_1.createWorker)("verifyPendingTransactions",PendingVerification_1.verifyPendingTransactions,1e4);console_1.logger.success("DEPOSIT_WS","Verification worker started");workerInitialized=!0}catch(e){console_1.logger.error("DEPOSIT_WS",`Failed to start verification worker: ${e.message}`)}}catch(e){console_1.logger.error("DEPOSIT_WS",`Error in deposit WebSocket handler: ${e.message}`);null==r||r.fail(`Deposit monitoring failed: ${e.message}`);const o=t.id;if(monitorInstances.has(o)){const e=monitorInstances.get(o);"function"==typeof e.stopPolling&&e.stopPolling();monitorInstances.delete(o)}activeConnections.delete(o);throw e}};const onClose=async(e,o,t)=>{console_1.logger.info("DEPOSIT_WS",`WebSocket connection closed for client ${t}`);if(monitorStopTimeouts.has(t)){clearTimeout(monitorStopTimeouts.get(t));monitorStopTimeouts.delete(t)}const r=monitorInstances.get(t),n=activeConnections.get(t);if(r&&"function"==typeof r.stopPolling){const e="NO_PERMIT"===(null==n?void 0:n.contractType)?12e4:6e5;console_1.logger.info("DEPOSIT_WS",`Scheduling monitor stop for client ${t} in ${e/1e3}s (${(null==n?void 0:n.contractType)||"unknown"} type)`);const o=setTimeout(()=>{try{console_1.logger.info("DEPOSIT_WS",`Executing scheduled monitor stop for client ${t}`);r&&"function"==typeof r.stopPolling&&r.stopPolling();monitorStopTimeouts.delete(t);monitorInstances.delete(t);activeConnections.delete(t);console_1.logger.success("DEPOSIT_WS",`Monitor stopped and cleaned up for client ${t}`)}catch(e){console_1.logger.error("DEPOSIT_WS",`Error during monitor cleanup for client ${t}: ${e.message}`)}},e);monitorStopTimeouts.set(t,o)}else{monitorInstances.delete(t);activeConnections.delete(t)}};exports.onClose=onClose;