"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("../order/utils"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Retrieves historical data for a specific symbol",description:"Fetches historical price data based on the specified interval and date range.",operationId:"getHistoricalData",tags:["Market","Historical"],logModule:"ECOSYSTEM",logTitle:"Get historical chart data",parameters:[{name:"symbol",in:"query",required:!0,schema:{type:"string",description:"Trading symbol, e.g., BTC/USD"}},{name:"from",in:"query",required:!0,schema:{type:"number",description:"Start timestamp for historical data"}},{name:"to",in:"query",required:!0,schema:{type:"number",description:"End timestamp for historical data"}},{name:"interval",in:"query",required:!0,schema:{type:"string",description:"Time interval for the data, e.g., 1m, 5m, 1h"}}],responses:{200:{description:"Historical data retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseHistoricalDataSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Chart"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{query:r,ctx:t}=e,{symbol:a,from:i,to:s,interval:o}=r;null==t||t.step("Validating query parameters");if(!i||!s||!o){null==t||t.fail("Missing required parameters");throw(0,error_1.createError)({statusCode:400,message:"Both `from`, `to`, and `interval` must be provided."})}null==t||t.step(`Fetching historical candles for ${a}`);const n=await(0,queries_1.getHistoricalCandles)(a,o,Number(i),Number(s));null==t||t.success(`Retrieved ${(null==n?void 0:n.length)||0} candles for ${a}`);return n};