"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("../utils");exports.metadata={summary:"Retrieves all ecommerce products",description:"Fetches a list of all active ecommerce products, including their categories and aggregated review stats.",operationId:"getEcommerceProducts",tags:["Ecommerce","Products"],logModule:"ECOM",logTitle:"Get Products",responses:{200:{description:"Products retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{...utils_1.baseProductSchema,rating:{type:"number",description:"Average rating"},reviewsCount:{type:"number",description:"Number of reviews"}},required:["id","name","slug"]}}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:r}=e;null==r||r.step("Fetching Products");try{const e=await db_1.models.ecommerceProduct.findAll({where:{status:!0},include:[{model:db_1.models.ecommerceCategory,as:"category",attributes:["id","name","slug"]},{model:db_1.models.ecommerceReview,as:"ecommerceReviews",attributes:["id","rating","userId","status","createdAt"],required:!1}],order:[["createdAt","DESC"]]});if(!e||0===e.length)return[];const t=e.map(e=>{const r=e.toJSON(),t=r.ecommerceReviews||[],s=t.length>0?t.reduce((e,r)=>e+(r.rating||0),0)/t.length:0;return{...r,rating:s,reviewsCount:t.length}});null==r||r.success("Get Products fetched successfully");return JSON.parse(JSON.stringify(t))}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error retrieving products: ${e.message}`})}};