"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Retrieves all active ecommerce categories",description:"Fetches all active ecommerce categories along with their active products, with calculated ratings and review counts for each product.",operationId:"listEcommerceCategories",tags:["Ecommerce","Categories"],logModule:"ECOM",logTitle:"Get Categories",responses:{200:{description:"Ecommerce categories retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseCategorySchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecommerce Category"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:r}=e;null==r||r.step("Fetching Categories");const t=await db_1.models.ecommerceCategory.findAll({where:{status:!0},attributes:["id","name","slug","description","image","status","createdAt"],include:[{model:db_1.models.ecommerceProduct,as:"ecommerceProducts",where:{status:!0},attributes:["id","name","slug","description","shortDescription","type","price","status","image","currency","inventoryQuantity","createdAt"],include:[{model:db_1.models.ecommerceReview,as:"ecommerceReviews",attributes:["id","productId","userId","rating","status","createdAt"]}],order:[["name","ASC"]]}]});if(!t)throw(0,error_1.createError)({statusCode:404,message:"No categories found"});if(0===t.length)return[];try{const e=t.map(e=>{const r=e.toJSON(),{ecommerceProducts:t,...s}=r;return{...s,products:t.map(e=>{var r,t,s;return{...e,rating:(null===(r=e.ecommerceReviews)||void 0===r?void 0:r.length)?e.ecommerceReviews.reduce((e,r)=>e+r.rating,0)/e.ecommerceReviews.length:0,reviewsCount:null!==(s=null===(t=e.ecommerceReviews)||void 0===t?void 0:t.length)&&void 0!==s?s:0}})}});null==r||r.success("Get Categories fetched successfully");return JSON.parse(JSON.stringify(e))}catch(e){console.error("Error fetching categories:",e);throw(0,error_1.createError)({statusCode:500,message:"Error fetching category data"})}};