"use strict";async function getMatchingEngine(){try{return(await Promise.resolve().then(()=>__importStar(require("@b/api/(ext)/ecosystem/utils/matchingEngine")))).MatchingEngine.getInstance()}catch(e){console_1.logger.error("COPY_TRADING","Failed to load matching engine",e);return null}}async function getPriceInUSDT(e){if("USDT"===e||"USD"===e)return 1;const r=`${PRICE_CACHE_PREFIX}${e}`;try{const e=await redis.get(r);if(e){const r=parseFloat(e);if(!isNaN(r)&&r>0)return r}}catch(r){console_1.logger.warn("COPY_TRADING",`Cache read failed for ${e} price`,r)}const t=await getMatchingEngine();if(!t)throw(0,error_1.createError)({statusCode:503,message:`Unable to get price for ${e}: Matching engine unavailable`});try{const n=`${e}/USDT`,o=await t.getTicker(n),a=null==o?void 0:o.last;if(null==a||isNaN(a))throw(0,error_1.createError)({statusCode:500,message:`Invalid price data for ${n}`});try{await redis.set(r,a.toString(),"EX",PRICE_CACHE_TTL)}catch(r){console_1.logger.warn("COPY_TRADING",`Cache write failed for ${e} price`,r)}return a}catch(r){console_1.logger.error("COPY_TRADING",`Error fetching price for ${e}/USDT`,r);throw(0,error_1.createError)({statusCode:500,message:`Unable to get price for ${e}: ${r.message}`})}}async function getPairPrice(e){const r=await getMatchingEngine();if(!r)throw(0,error_1.createError)({statusCode:503,message:`Unable to get price for ${e}: Matching engine unavailable`});try{const t=await r.getTicker(e),n=null==t?void 0:t.last;if(null==n||isNaN(n))throw(0,error_1.createError)({statusCode:500,message:`Invalid price data for ${e}`});return n}catch(r){console_1.logger.error("COPY_TRADING",`Error fetching price for ${e}`,r);throw(0,error_1.createError)({statusCode:500,message:`Unable to get price for ${e}: ${r.message}`})}}async function convertToUSDT(e,r){if("USDT"===r||"USD"===r)return e;return e*await getPriceInUSDT(r)}async function convertFromUSDT(e,r){if("USDT"===r||"USD"===r)return e;const t=await getPriceInUSDT(r);if(0===t)throw(0,error_1.createError)({statusCode:400,message:`Cannot convert to ${r}: price is 0`});return e/t}async function convertCurrency(e,r,t){if(r===t)return e;const n=await convertToUSDT(e,r);return await convertFromUSDT(n,t)}async function sumToUSDT(e){let r=0;for(const{amount:t,currency:n}of e){r+=await convertToUSDT(t,n)}return r}async function calculateProfitInUSDT(e,r){return await convertToUSDT(e,r)}function parseSymbol(e){const r=e.split("/");if(2!==r.length)throw(0,error_1.createError)({statusCode:400,message:`Invalid symbol format: ${e}`});return{base:r[0],quote:r[1]}}function getQuoteCurrency(e){return parseSymbol(e).quote}function getBaseCurrency(e){return parseSymbol(e).base}function getTradeCurrency(e,r){const{base:t,quote:n}=parseSymbol(e);return"BUY"===r?{spend:n,receive:t}:{spend:t,receive:n}}function getCurrencySymbol(e){return CURRENCY_SYMBOLS[e]||e}function formatCurrencyAmount(e,r,t=2){const n=getCurrencySymbol(r),o=e.toFixed(t);return["USD","USDT","USDC","EUR","GBP","JPY"].includes(r)?`${n}${o}`:`${o} ${r}`}async function validateMinimumAmount(e,r,t){const n=await convertToUSDT(e,r);return n<t?{valid:!1,amountUSDT:n,message:`Amount ${formatCurrencyAmount(e,r)} (~${formatCurrencyAmount(n,"USDT")}) is below minimum ${formatCurrencyAmount(t,"USDT")}`}:{valid:!0,amountUSDT:n}}async function getPricesInUSDT(e){const r={};for(const t of e)try{r[t]=await getPriceInUSDT(t)}catch(e){console_1.logger.warn("COPY_TRADING",`Failed to get price for ${t}`,e);r[t]=0}return r}var __createBinding=this&&this.__createBinding||(Object.create?function(e,r,t,n){void 0===n&&(n=t);var o=Object.getOwnPropertyDescriptor(r,t);o&&!("get"in o?!r.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return r[t]}});Object.defineProperty(e,n,o)}:function(e,r,t,n){void 0===n&&(n=t);e[n]=r[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,r){Object.defineProperty(e,"default",{enumerable:!0,value:r})}:function(e,r){e.default=r}),__importStar=this&&this.__importStar||function(){var e=function(r){e=Object.getOwnPropertyNames||function(e){var r=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[r.length]=t);return r};return e(r)};return function(r){if(r&&r.__esModule)return r;var t={};if(null!=r)for(var n=e(r),o=0;o<n.length;o++)"default"!==n[o]&&__createBinding(t,r,n[o]);__setModuleDefault(t,r);return t}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.getPriceInUSDT=getPriceInUSDT;exports.getPairPrice=getPairPrice;exports.convertToUSDT=convertToUSDT;exports.convertFromUSDT=convertFromUSDT;exports.convertCurrency=convertCurrency;exports.sumToUSDT=sumToUSDT;exports.calculateProfitInUSDT=calculateProfitInUSDT;exports.parseSymbol=parseSymbol;exports.getQuoteCurrency=getQuoteCurrency;exports.getBaseCurrency=getBaseCurrency;exports.getTradeCurrency=getTradeCurrency;exports.getCurrencySymbol=getCurrencySymbol;exports.formatCurrencyAmount=formatCurrencyAmount;exports.validateMinimumAmount=validateMinimumAmount;exports.getPricesInUSDT=getPricesInUSDT;const error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),redis_1=require("@b/utils/redis"),redis=redis_1.RedisSingleton.getInstance(),PRICE_CACHE_TTL=60,PRICE_CACHE_PREFIX="copy_trading:price:",CURRENCY_SYMBOLS={USD:"$",USDT:"$",USDC:"$",EUR:"€",GBP:"£",JPY:"¥",BTC:"₿",ETH:"Ξ"};