"use strict";async function processFollowerCopy(e,t,a,o){var r,s,i,d,c,n,l;let u=0;for(;u<MAX_RETRY_ATTEMPTS;){const p=await db_1.sequelize.transaction({isolationLevel:sequelize_1.Transaction.ISOLATION_LEVELS.SERIALIZABLE});try{const u=await db_1.models.copyTradingFollower.findByPk(t.id,{transaction:p,lock:p.LOCK.UPDATE});if(!u||"ACTIVE"!==u.status){await p.rollback();return!0}const g=u,y=await db_1.models.copyTradingFollowerAllocation.findOne({where:{followerId:t.id,symbol:e.symbol,isActive:!0},transaction:p,lock:p.LOCK.UPDATE});if(!y){await p.rollback();(0,broadcast_1.broadcastLog)(o,`Skipping follower ${t.id}: no allocation for ${e.symbol}`,"info");return!0}const _=y,f="BUY"===e.side?_.quoteAmount-_.quoteUsedAmount:_.baseAmount-_.baseUsedAmount;if(f<=0){await p.rollback();(0,broadcast_1.broadcastLog)(o,`Skipping follower ${t.id}: insufficient ${e.symbol} allocation for ${e.side}`,"info");return!0}const{amount:b,cost:m,reason:w}=(0,copyProcessor_1.calculateCopyAmount)(e.amount,e.price,a,g,f);if(b<=0){await p.rollback();(0,broadcast_1.broadcastLog)(o,`Skipping follower ${t.id}: ${w||"zero copy amount calculated"}`,"info");return!0}const T=(0,currency_1.getBaseCurrency)(e.symbol),L=(0,currency_1.getQuoteCurrency)(e.symbol),A=await db_1.models.ecosystemMarket.findOne({where:{currency:T,pair:L},transaction:p});if(!A){await p.rollback();throw(0,error_1.createError)({statusCode:404,message:`Market not found: ${e.symbol}`})}const $=A,C=Number((null===(i=null===(s=null===(r=$.metadata)||void 0===r?void 0:r.limits)||void 0===s?void 0:s.amount)||void 0===i?void 0:i.min)||0);if(b<C){await p.rollback();(0,broadcast_1.broadcastLog)(o,`Skipping follower ${t.id}: copy amount ${b} below minimum ${C}`,"info");return!0}const{spend:D}=(0,currency_1.getTradeCurrency)(e.symbol,e.side),I=await(0,safe_imports_1.getWalletByUserIdAndCurrency)(t.userId,D);if(!I){await p.rollback();throw(0,error_1.createError)({statusCode:404,message:`Wallet not found for user ${t.userId} currency ${D}`})}let S=e.price;if("market"===e.type.toLowerCase()){const{asks:t,bids:a}=await(0,safe_imports_1.getOrderBook)(e.symbol);S="BUY"===e.side?t&&t.length>0?t[0][0]:e.price:a&&a.length>0?a[0][0]:e.price}const h=Number((null===(c=null===(d=$.metadata)||void 0===d?void 0:d.precision)||void 0===c?void 0:c.price)||8),E=Number((null===(n=$.metadata)||void 0===n?void 0:n.taker)||.1),P=parseFloat((b*S*E/100).toFixed(h)),R="BUY"===e.side?parseFloat((b*S+P).toFixed(h)):b,O=parseFloat(I.balance.toString())-parseFloat((null===(l=I.inOrder)||void 0===l?void 0:l.toString())||"0");if(O<R){await p.rollback();(0,broadcast_1.broadcastLog)(o,`Skipping follower ${t.id}: insufficient ${D} balance (${O} < ${R})`,"warning");return!0}const k=await(0,safe_imports_1.createOrder)({userId:t.userId,symbol:e.symbol,amount:await(0,safe_imports_1.toBigIntFloat)(b),price:await(0,safe_imports_1.toBigIntFloat)(S),cost:await(0,safe_imports_1.toBigIntFloat)(R),type:"market"===e.type.toLowerCase()?"MARKET":"LIMIT",side:e.side,fee:await(0,safe_imports_1.toBigIntFloat)(P),feeCurrency:L});await(0,safe_imports_1.updateWalletBalance)(I,R,"subtract");await db_1.models.copyTradingTrade.create({followerId:t.id,leaderId:e.leaderId,leaderTradeId:e.id,symbol:e.symbol,side:e.side,type:e.type,amount:b,price:S,cost:R,fee:P,feeCurrency:L,profitCurrency:L,status:"OPEN",orderId:k.id,isLeaderTrade:!1},{transaction:p});"BUY"===e.side?await _.update({quoteUsedAmount:(0,sequelize_1.literal)(`"quoteUsedAmount" + ${R}`)},{transaction:p}):await _.update({baseUsedAmount:(0,sequelize_1.literal)(`"baseUsedAmount" + ${b}`)},{transaction:p});await db_1.models.copyTradingTransaction.create({userId:t.userId,followerId:t.id,leaderId:e.leaderId,type:"TRADE_OPEN",amount:R,currency:D,description:`Copied ${e.side} trade: ${b.toFixed(6)} ${T} @ ${S} ${L}`,metadata:JSON.stringify({leaderTradeId:e.id,orderId:k.id,symbol:e.symbol,allocationId:_.id}),status:"COMPLETED"},{transaction:p});await p.commit();(0,broadcast_1.broadcastLog)(o,`Follower ${t.id} copied trade: ${e.side} ${b.toFixed(6)} ${T} @ ${S} ${L}`,"success");return!0}catch(e){await p.rollback();u++;console_1.logger.error("COPY_TRADING",`Failed to process follower ${t.id} copy`,e);if(!(u<MAX_RETRY_ATTEMPTS)){console_1.logger.error("COPY_TRADING",`Failed to copy for follower ${t.id}: ${e.message}`,e);(0,broadcast_1.broadcastLog)(o,`Failed to copy for follower ${t.id}: ${e.message}`,"error");return!1}(0,broadcast_1.broadcastLog)(o,`Retrying follower ${t.id} copy (Attempt ${u+1}/${MAX_RETRY_ATTEMPTS}): ${e.message}`,"warning");await new Promise(e=>setTimeout(e,RETRY_DELAY_MS))}}return!1}async function replicateLeaderTrade(e,t){const a="replicateLeaderTrade";try{(0,broadcast_1.broadcastLog)(a,`Replicating trade ${e.id} for leader ${e.leaderId}`);const o=await db_1.models.copyTradingFollower.findAll({where:{leaderId:e.leaderId,status:"ACTIVE"},include:[{model:db_1.models.user,as:"user"}]});if(0===o.length){(0,broadcast_1.broadcastLog)(a,`No active followers for leader ${e.leaderId}`,"info");return}(0,broadcast_1.broadcastLog)(a,`Found ${o.length} active followers to replicate to`);const r=await processWithConcurrency(o,MAX_CONCURRENCY,async o=>processFollowerCopy(e,o,t,a)),s=r.filter(e=>e).length,i=r.filter(e=>!e).length;(0,broadcast_1.broadcastLog)(a,`Trade replication complete: ${s} successful, ${i} failed`,s>0?"success":"warning")}catch(e){console_1.logger.error("COPY_TRADING",`Trade replication failed: ${e.message}`,e);(0,broadcast_1.broadcastLog)(a,`Trade replication failed: ${e.message}`,"error");throw e}}async function processPendingCopyTrades(){const e="processPendingCopyTrades",t=Date.now();let a=0,o=0;try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting copy trade replication process");const r=await db_1.models.settings.findOne({where:{key:"copyTradingEnabled"}});if(!r||"true"!==r.value){(0,broadcast_1.broadcastLog)(e,"Copy trading is disabled, skipping","info");(0,broadcast_1.broadcastStatus)(e,"completed",{skipped:!0});return}const s=await db_1.models.copyTradingTrade.findAll({where:{followerId:null,status:"PENDING_REPLICATION"},include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user"}]}],order:[["createdAt","ASC"]],limit:50});if(0===s.length){(0,broadcast_1.broadcastLog)(e,"No pending trades to replicate","info");(0,broadcast_1.broadcastStatus)(e,"completed",{processed:0});return}(0,broadcast_1.broadcastLog)(e,`Found ${s.length} pending trades to replicate`);for(const t of s)try{const o=t.leader;if(!o){(0,broadcast_1.broadcastLog)(e,`Leader not found for trade ${t.id}`,"warning");continue}const r=await(0,safe_imports_1.getWalletByUserIdAndCurrency)(o.userId,t.symbol.split("/")[1]),s=r?parseFloat(r.balance.toString()):0;await replicateLeaderTrade(t,s);await t.update({status:"REPLICATED"});a++}catch(a){console_1.logger.error("COPY_TRADING",`Failed to replicate trade ${t.id}`,a);(0,broadcast_1.broadcastLog)(e,`Failed to replicate trade ${t.id}: ${a.message}`,"error");await t.update({status:"REPLICATION_FAILED"});o++}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t,processed:a,failed:o});(0,broadcast_1.broadcastLog)(e,`Copy trade replication completed: ${a} processed, ${o} failed`,"success")}catch(r){console_1.logger.error("COPY_TRADING",`Copy trade replication failed: ${r.message}`,r);(0,broadcast_1.broadcastStatus)(e,"failed",{duration:Date.now()-t,processed:a,failed:o,error:r.message});(0,broadcast_1.broadcastLog)(e,`Copy trade replication failed: ${r.message}`,"error");throw r}}async function processClosedCopyTrades(){const e="processClosedCopyTrades",t=Date.now();let a=0,o=0;try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting closed copy trade processing");const r=await db_1.models.copyTradingTrade.findAll({where:{followerId:{[sequelize_1.Op.ne]:null},status:"CLOSED",profit:null},include:[{model:db_1.models.copyTradingFollower,as:"follower",include:[{model:db_1.models.copyTradingLeader,as:"leader"},{model:db_1.models.user,as:"user"}]}],limit:100});if(0===r.length){(0,broadcast_1.broadcastLog)(e,"No closed trades to process","info");(0,broadcast_1.broadcastStatus)(e,"completed",{processed:0});return}(0,broadcast_1.broadcastLog)(e,`Found ${r.length} closed trades to process`);for(const t of r){const r=await db_1.sequelize.transaction();try{const o=t.follower,s=null==o?void 0:o.leader;if(!o||!s){await r.rollback();continue}const i=t.closedProfit||0,d=t.cost>0?i/t.cost*100:0,c=2,n=s.profitSharePercent||20;let l=0,u=0,p=i;if(i>0){u=i*(c/100);l=n/100*(i-u);p=i-u-l}await t.update({profit:p,profitPercent:d},{transaction:r});const g=await db_1.models.copyTradingFollowerAllocation.findOne({where:{followerId:o.id,symbol:t.symbol},transaction:r});if(g){const e=g;"BUY"===t.side?await e.update({quoteUsedAmount:(0,sequelize_1.literal)(`GREATEST(0, "quoteUsedAmount" - ${t.cost})`)},{transaction:r}):await e.update({baseUsedAmount:(0,sequelize_1.literal)(`GREATEST(0, "baseUsedAmount" - ${t.amount})`)},{transaction:r})}if(i>0){const e=t.profitCurrency||t.symbol.split("/")[1]||"USDT";await db_1.models.copyTradingTransaction.create({followerId:o.id,type:"PLATFORM_FEE",amount:u,currency:e,description:`Platform fee for trade ${t.id}`,metadata:{tradeId:t.id}},{transaction:r});await db_1.models.copyTradingTransaction.create({followerId:o.id,type:"PROFIT_SHARE",amount:l,currency:e,description:`Leader profit share for trade ${t.id}`,metadata:{tradeId:t.id,leaderId:s.id}},{transaction:r});const a=await(0,safe_imports_1.getWalletByUserIdAndCurrency)(s.userId,e);a&&await(0,safe_imports_1.updateWalletBalance)(a,l,"add")}const[,y]=t.symbol.split("/"),_=t.cost+p,f=await(0,safe_imports_1.getWalletByUserIdAndCurrency)(o.userId,y);f&&_>0&&await(0,safe_imports_1.updateWalletBalance)(f,_,"add");await(0,notifications_1.createNotification)({userId:o.userId,type:"system",title:i>0?"Copy Trade Profit":"Copy Trade Closed",message:i>0?`Your copied trade made ${p.toFixed(2)} ${y} profit!`:`Your copied trade closed with ${p.toFixed(2)} ${y} ${i<0?"loss":""}.`,link:"/copy-trading/subscriptions"});await r.commit();a++;try{await(0,stats_calculator_1.invalidateTradeRelatedCaches)(s.id,o.id,t.symbol)}catch(e){console_1.logger.warn("COPY_TRADING",`Failed to invalidate cache for trade ${t.id}`,e)}(0,broadcast_1.broadcastLog)(e,`Processed trade ${t.id}: profit=${i.toFixed(2)}, followerShare=${p.toFixed(2)}, leaderShare=${l.toFixed(2)}`,"success")}catch(a){await r.rollback();console_1.logger.error("COPY_TRADING",`Failed to process closed trade ${t.id}`,a);(0,broadcast_1.broadcastLog)(e,`Failed to process trade ${t.id}: ${a.message}`,"error");o++}}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t,processed:a,failed:o});(0,broadcast_1.broadcastLog)(e,`Closed trade processing completed: ${a} processed, ${o} failed`,"success")}catch(r){console_1.logger.error("COPY_TRADING",`Closed trade processing failed: ${r.message}`,r);(0,broadcast_1.broadcastStatus)(e,"failed",{duration:Date.now()-t,processed:a,failed:o,error:r.message});(0,broadcast_1.broadcastLog)(e,`Closed trade processing failed: ${r.message}`,"error");throw r}}async function updateLeaderDailyStats(){const e="updateLeaderDailyStats",t=Date.now();try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting leader daily stats update");const a=new Date;a.setHours(0,0,0,0);const o=await db_1.models.copyTradingLeader.findAll({where:{status:"ACTIVE"}});for(const t of o)try{const o=await db_1.models.copyTradingTrade.findAll({where:{leaderId:t.id,followerId:null,createdAt:{[sequelize_1.Op.gte]:a}},attributes:["id","profit","amount","price","symbol","profitCurrency"]}),r=o.length,s=o.filter(e=>(e.profit||0)>0).length;let i=0,d=0;for(const e of o){const t=e.profit||0,a=(e.amount||0)*(e.price||0);let o=e.profitCurrency;!o&&e.symbol&&(o=(0,currency_1.getQuoteCurrency)(e.symbol));o||(o="USDT");try{const e=await(0,currency_1.convertToUSDT)(t,o),r=await(0,currency_1.convertToUSDT)(a,o);i+=e;d+=r}catch(e){console_1.logger.warn("COPY_TRADING",`Currency conversion failed for ${o}`,e);i+=t;d+=a}}await db_1.models.copyTradingLeaderStats.upsert({leaderId:t.id,date:a,trades:r,winningTrades:s,losingTrades:r-s,profit:i,volume:d,fees:0,startEquity:0,endEquity:0,highEquity:0,lowEquity:0});(0,broadcast_1.broadcastLog)(e,`Updated stats for leader ${t.id}: trades=${r}, profit=${(0,currency_1.formatCurrencyAmount)(i,"USDT")}`,"info")}catch(a){console_1.logger.error("COPY_TRADING",`Failed to update stats for leader ${t.id}`,a);(0,broadcast_1.broadcastLog)(e,`Failed to update stats for leader ${t.id}: ${a.message}`,"error")}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t,leaders:o.length});(0,broadcast_1.broadcastLog)(e,`Leader stats update completed for ${o.length} leaders`,"success")}catch(a){console_1.logger.error("COPY_TRADING",`Leader stats update failed: ${a.message}`,a);(0,broadcast_1.broadcastStatus)(e,"failed",{duration:Date.now()-t,error:a.message});throw a}}async function processWithConcurrency(e,t,a){const o=new Array(e.length);let r=0;const s=new Array(t).fill(0).map(async()=>{for(;r<e.length;){const t=r++;try{o[t]=await a(e[t])}catch(e){o[t]=e}}});await Promise.all(s);return o}async function resetDailyLimits(){const e="resetDailyLimits",t=Date.now();let a=0,o=0;try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting daily limits reset");const r=await db_1.models.copyTradingFollower.findAll({where:{status:"PAUSED"}});for(const t of r){if(await db_1.models.copyTradingAuditLog.findOne({where:{entityType:"copyTradingFollower",entityId:t.id,action:"DAILY_LOSS_LIMIT_REACHED",createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-864e5)}}})){await t.update({status:"ACTIVE"});o++;await(0,notifications_1.createNotification)({userId:t.userId,type:"system",title:"Copy Trading Resumed",message:"Your copy trading subscription has been automatically reactivated for the new trading day.",link:"/copy-trading/subscription"});(0,broadcast_1.broadcastLog)(e,`Reactivated follower ${t.id}`,"info")}}a=1;(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t,reset:a,reactivated:o});(0,broadcast_1.broadcastLog)(e,`Daily limits reset: ${o} followers reactivated`,"success")}catch(a){console_1.logger.error("COPY_TRADING",`Daily limits reset failed: ${a.message}`,a);(0,broadcast_1.broadcastStatus)(e,"failed",{duration:Date.now()-t,error:a.message});throw a}}async function aggregateWeeklyAnalytics(){const e="aggregateWeeklyAnalytics",t=Date.now();let a=0;try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting weekly analytics aggregation");const o=new Date;o.setDate(o.getDate()-7);o.setHours(0,0,0,0);const r=await db_1.models.copyTradingLeader.findAll({where:{status:"ACTIVE"}});for(const t of r)try{const r=await db_1.models.copyTradingTrade.findAll({where:{leaderId:t.id,isLeaderTrade:!0,status:"CLOSED",closedAt:{[sequelize_1.Op.gte]:o}},attributes:["id","profit","cost","symbol","profitCurrency"]}),s=r.length;r.filter(e=>(e.profit||0)>0).length;let i=0,d=0;for(const e of r){const t=e.profit||0,a=e.cost||0;let o=e.profitCurrency;!o&&e.symbol&&(o=(0,currency_1.getQuoteCurrency)(e.symbol));o||(o="USDT");try{const e=await(0,currency_1.convertToUSDT)(t,o),r=await(0,currency_1.convertToUSDT)(a,o);i+=e;d+=r}catch(e){console_1.logger.warn("COPY_TRADING",`Currency conversion failed for ${o}`,e);i+=t;d+=a}}a++;(0,broadcast_1.broadcastLog)(e,`Aggregated stats for leader ${t.id}: weekly trades=${s}, profit=${(0,currency_1.formatCurrencyAmount)(i,"USDT")}`,"info")}catch(e){console_1.logger.error("COPY_TRADING",`Failed to aggregate stats for leader ${t.id}`,e)}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t,processed:a});(0,broadcast_1.broadcastLog)(e,`Weekly analytics aggregation completed for ${a} leaders`,"success")}catch(a){console_1.logger.error("COPY_TRADING",`Weekly analytics aggregation failed: ${a.message}`,a);(0,broadcast_1.broadcastStatus)(e,"failed",{duration:Date.now()-t,error:a.message});throw a}}async function monitorStopLevels(){const e="monitorStopLevels",t=Date.now();let a=0,o=0;try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting stop-loss/take-profit monitoring");const r=await db_1.models.copyTradingTrade.findAll({where:{followerId:{[sequelize_1.Op.ne]:null},status:"OPEN"},include:[{model:db_1.models.copyTradingFollower,as:"follower",where:{[sequelize_1.Op.or]:[{stopLossPercent:{[sequelize_1.Op.ne]:null}},{takeProfitPercent:{[sequelize_1.Op.ne]:null}}]}}]});for(const t of r){a++;const r=t.follower;if(!r)continue;const[s,i]=t.symbol.split("/");let d=t.price;try{const{asks:e,bids:a}=await(0,safe_imports_1.getOrderBook)(t.symbol);d="BUY"===t.side?a&&a.length>0?a[0][0]:t.price:e&&e.length>0?e[0][0]:t.price}catch(e){}const c=t.executedPrice||t.price,n="BUY"===t.side;if(r.stopLossPercent){const a=n?c*(1-r.stopLossPercent/100):c*(1+r.stopLossPercent/100);if(n?d<=a:d>=a){(0,broadcast_1.broadcastLog)(e,`Stop-loss triggered for trade ${t.id} at ${d}`,"warning");o++;continue}}if(r.takeProfitPercent){const a=n?c*(1+r.takeProfitPercent/100):c*(1-r.takeProfitPercent/100);if(n?d>=a:d<=a){(0,broadcast_1.broadcastLog)(e,`Take-profit triggered for trade ${t.id} at ${d}`,"success");o++}}}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-t,checked:a,triggered:o});(0,broadcast_1.broadcastLog)(e,`Stop-loss/take-profit monitoring: ${a} checked, ${o} triggered`,"success")}catch(a){console_1.logger.error("COPY_TRADING",`Stop-loss/take-profit monitoring failed: ${a.message}`,a);(0,broadcast_1.broadcastStatus)(e,"failed",{duration:Date.now()-t,error:a.message});throw a}}async function checkDailyLossLimits(){var e,t;const a="checkDailyLossLimits",o=Date.now();let r=0,s=0,i=0;for(;i<MAX_RETRY_ATTEMPTS;)try{(0,broadcast_1.broadcastStatus)(a,"running");i>0?(0,broadcast_1.broadcastLog)(a,`Retrying daily loss limit check (attempt ${i+1}/${MAX_RETRY_ATTEMPTS})`):(0,broadcast_1.broadcastLog)(a,"Checking daily loss limits");const e=new Date;e.setHours(0,0,0,0);const t=await db_1.models.copyTradingFollower.findAll({where:{status:"ACTIVE",maxDailyLoss:{[sequelize_1.Op.gt]:0}}});for(const o of t){r++;const t=await db_1.models.copyTradingTrade.findAll({where:{followerId:o.id,status:"CLOSED",closedAt:{[sequelize_1.Op.gte]:e},profit:{[sequelize_1.Op.lt]:0}},attributes:["profit","symbol","profitCurrency"]});let i=0;for(const e of t){const t=Math.abs(e.profit||0);let a=e.profitCurrency;!a&&e.symbol&&(a=(0,currency_1.getQuoteCurrency)(e.symbol));a||(a="USDT");try{i+=await(0,currency_1.convertToUSDT)(t,a)}catch(e){console_1.logger.warn("COPY_TRADING",`Currency conversion failed for ${a}`,e);i+=t}}if(i>=o.maxDailyLoss){await o.update({status:"PAUSED"});s++;await(0,notifications_1.createNotification)({userId:o.userId,type:"system",title:"Copy Trading Paused",message:`Your copy trading has been paused due to reaching your daily loss limit of ${(0,currency_1.formatCurrencyAmount)(o.maxDailyLoss,"USDT")}. Current loss: ${(0,currency_1.formatCurrencyAmount)(i,"USDT")}`,link:"/copy-trading/subscription"});await db_1.models.copyTradingAuditLog.create({entityType:"copyTradingFollower",entityId:o.id,action:"DAILY_LOSS_LIMIT_REACHED",userId:o.userId,metadata:JSON.stringify({totalLoss:i,maxDailyLoss:o.maxDailyLoss,currency:"USDT"})});(0,broadcast_1.broadcastLog)(a,`Paused follower ${o.id} due to daily loss limit: ${(0,currency_1.formatCurrencyAmount)(i,"USDT")} >= ${(0,currency_1.formatCurrencyAmount)(o.maxDailyLoss,"USDT")}`,"warning")}}(0,broadcast_1.broadcastStatus)(a,"completed",{duration:Date.now()-o,checked:r,paused:s});(0,broadcast_1.broadcastLog)(a,`Daily loss limit check: ${r} checked, ${s} paused`,"success");return}catch(d){i++;if(("ECONNRESET"===d.code||"ETIMEDOUT"===d.code||"ENOTFOUND"===d.code||"ECONNREFUSED"===d.code||(null===(e=d.message)||void 0===e?void 0:e.includes("ECONNRESET"))||(null===(t=d.message)||void 0===t?void 0:t.includes("read ECONNRESET")))&&i<MAX_RETRY_ATTEMPTS){console_1.logger.warn("COPY_TRADING",`Connection error in daily loss limit check, retrying (${i}/${MAX_RETRY_ATTEMPTS}): ${d.message}`);(0,broadcast_1.broadcastLog)(a,`Connection error, retrying in ${RETRY_DELAY_MS}ms...`,"warning");await new Promise(e=>setTimeout(e,RETRY_DELAY_MS*i));r=0;s=0;continue}console_1.logger.error("COPY_TRADING",`Daily loss limit check failed: ${d.message}`,d);(0,broadcast_1.broadcastStatus)(a,"failed",{duration:Date.now()-o,error:d.message,retryAttempts:i});throw d}}Object.defineProperty(exports,"__esModule",{value:!0});exports.replicateLeaderTrade=replicateLeaderTrade;exports.processPendingCopyTrades=processPendingCopyTrades;exports.processClosedCopyTrades=processClosedCopyTrades;exports.updateLeaderDailyStats=updateLeaderDailyStats;exports.resetDailyLimits=resetDailyLimits;exports.aggregateWeeklyAnalytics=aggregateWeeklyAnalytics;exports.monitorStopLevels=monitorStopLevels;exports.checkDailyLossLimits=checkDailyLossLimits;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),broadcast_1=require("@b/cron/broadcast"),console_1=require("@b/utils/console"),notifications_1=require("@b/utils/notifications"),safe_imports_1=require("@b/utils/safe-imports"),currency_1=require("./currency"),copyProcessor_1=require("./copyProcessor"),stats_calculator_1=require("@b/api/(ext)/copy-trading/utils/stats-calculator"),MAX_CONCURRENCY=3,MAX_RETRY_ATTEMPTS=3,RETRY_DELAY_MS=2e3;