"use strict";async function queueLeaderTrade(e,s,r,o=0){const t=CopyTradeQueue.getInstance();await t.enqueue(e,s,r,o)}function startCopyQueue(){CopyTradeQueue.getInstance().start()}function stopCopyQueue(){CopyTradeQueue.getInstance().stop()}function getCopyQueueStats(){return CopyTradeQueue.getInstance().getStats()}Object.defineProperty(exports,"__esModule",{value:!0});exports.CopyTradeQueue=void 0;exports.queueLeaderTrade=queueLeaderTrade;exports.startCopyQueue=startCopyQueue;exports.stopCopyQueue=stopCopyQueue;exports.getCopyQueueStats=getCopyQueueStats;const console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),copyProcessor_1=require("./copyProcessor"),db_1=require("@b/db"),CONFIG={MAX_CONCURRENT_FOLLOWERS:10,QUEUE_PROCESS_INTERVAL:100,MAX_QUEUE_SIZE:1e3,BATCH_SIZE:50,MAX_RETRIES:3,RETRY_DELAY:1e3};class CopyTradeQueue{constructor(){this.pendingQueue=[];this.processingSet=new Set;this.completedCount=0;this.failedCount=0;this.processingTimes=[];this.isProcessing=!1;this.processInterval=null}static getInstance(){CopyTradeQueue.instance||(CopyTradeQueue.instance=new CopyTradeQueue);return CopyTradeQueue.instance}start(){if(this.processInterval)console_1.logger.warn("COPY_TRADING","Queue processor already running");else{this.processInterval=setInterval(()=>{this.processQueue().catch(e=>{console_1.logger.error("COPY_TRADING","Queue processing error",e)})},CONFIG.QUEUE_PROCESS_INTERVAL);console_1.logger.info("COPY_TRADING","Copy trade queue processor started")}}stop(){if(this.processInterval){clearInterval(this.processInterval);this.processInterval=null;console_1.logger.info("COPY_TRADING","Copy trade queue processor stopped")}}async enqueue(e,s,r,o=0){this.pendingQueue.length>=CONFIG.MAX_QUEUE_SIZE&&console_1.logger.warn("COPY_TRADING",`Queue size limit reached (${CONFIG.MAX_QUEUE_SIZE})`);const t={id:`${e}_${Date.now()}`,leaderTradeId:e,leaderId:s,symbol:r,priority:o,createdAt:new Date,retries:0},i=this.pendingQueue.findIndex(e=>e.priority<o);-1===i?this.pendingQueue.push(t):this.pendingQueue.splice(i,0,t);console_1.logger.debug("COPY_TRADING",`Enqueued trade ${e} (priority: ${o}, queue size: ${this.pendingQueue.length})`)}async processQueue(){if(!this.isProcessing&&0!==this.pendingQueue.length){this.isProcessing=!0;try{const e=this.pendingQueue.shift();if(!e)return;this.processingSet.add(e.id);const s=Date.now();try{await this.processTask(e);this.completedCount++;const r=Date.now()-s;this.processingTimes.push(r);this.processingTimes.length>100&&this.processingTimes.shift();console_1.logger.debug("COPY_TRADING",`Completed task ${e.id} in ${r}ms`)}catch(s){console_1.logger.error("COPY_TRADING",`Task ${e.id} failed`,s);if(e.retries<CONFIG.MAX_RETRIES){e.retries++;console_1.logger.info("COPY_TRADING",`Retrying task ${e.id} (attempt ${e.retries}/${CONFIG.MAX_RETRIES})`);setTimeout(()=>{this.pendingQueue.push(e)},CONFIG.RETRY_DELAY*e.retries)}else{this.failedCount++;console_1.logger.error("COPY_TRADING",`Task ${e.id} failed after ${CONFIG.MAX_RETRIES} retries`)}}finally{this.processingSet.delete(e.id)}}finally{this.isProcessing=!1}}}async processTask(e){var s;const r=await db_1.models.copyTradingTrade.findByPk(e.leaderTradeId,{include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user"}]}]});if(!r)throw(0,error_1.createError)({statusCode:404,message:`Leader trade ${e.leaderTradeId} not found`});const o=r,[t,i]=e.symbol.split("/");let n=0;try{const e=await db_1.models.wallet.findOne({where:{userId:null===(s=o.leader)||void 0===s?void 0:s.userId,currency:i,type:"ECO"}});n=e?parseFloat(e.balance):0}catch(e){}const a=await db_1.models.copyTradingFollower.findAll({where:{leaderId:e.leaderId,status:"ACTIVE"},include:[{model:db_1.models.copyTradingFollowerAllocation,as:"allocations",where:{symbol:e.symbol,isActive:!0},required:!0},{model:db_1.models.user,as:"user"}]});if(0!==a.length){console_1.logger.info("COPY_TRADING",`Processing ${a.length} followers for trade ${e.leaderTradeId}`);await this.processFollowersBatch(a,o,n)}else console_1.logger.debug("COPY_TRADING",`No active followers for leader ${e.leaderId} on ${e.symbol}`)}async processFollowersBatch(e,s,r){const o=CONFIG.MAX_CONCURRENT_FOLLOWERS;let t=0,i=0;for(let n=0;n<e.length;n+=o){const a=e.slice(n,n+o);(await Promise.allSettled(a.map(e=>this.processFollowerCopy(e,s,r)))).forEach((e,s)=>{if("fulfilled"===e.status&&e.value.success)t++;else{i++;const r=a[s],o="rejected"===e.status?e.reason:e.value.error;console_1.logger.warn("COPY_TRADING",`Failed to copy trade for follower ${r.id}: ${o}`)}})}console_1.logger.info("COPY_TRADING",`Batch complete: ${t} succeeded, ${i} failed`)}async processFollowerCopy(e,s,r){try{return await(0,copyProcessor_1.processCopyOrder)({leaderTrade:s,follower:e,leaderBalance:r})}catch(e){return{success:!1,error:e.message}}}getStats(){const e=this.processingTimes.length>0?this.processingTimes.reduce((e,s)=>e+s,0)/this.processingTimes.length:0;return{pending:this.pendingQueue.length,processing:this.processingSet.size,completed:this.completedCount,failed:this.failedCount,averageProcessingTime:Math.round(e)}}clearStats(){this.completedCount=0;this.failedCount=0;this.processingTimes=[]}getQueueSize(){return this.pendingQueue.length}}exports.CopyTradeQueue=CopyTradeQueue;CopyTradeQueue.instance=null;