"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("@b/api/(ext)/copy-trading/utils"),security_1=require("@b/api/(ext)/copy-trading/utils/security");exports.metadata={summary:"Update My Leader Profile",description:"Updates the current user's leader profile settings.",operationId:"updateMyLeaderProfile",tags:["Copy Trading","Leaders"],requiresAuth:!0,logModule:"COPY",logTitle:"Update leader profile",middleware:["copyTradingLeaderUpdate"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{displayName:{type:"string",minLength:2,maxLength:100},bio:{type:"string",maxLength:1e3},avatar:{type:"string"},tradingStyle:{type:"string",enum:["SCALPING","DAY_TRADING","SWING","POSITION"]},riskLevel:{type:"string",enum:["LOW","MEDIUM","HIGH"]},profitSharePercent:{type:"number",minimum:0,maximum:50},minFollowAmount:{type:"number",minimum:0},maxFollowers:{type:"number",minimum:1},isPublic:{type:"boolean"}}}}}},responses:{200:{description:"Profile updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},leader:{type:"object"}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},404:{description:"Not a leader"},429:{description:"Too Many Requests"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Validating request");const i=(0,security_1.validateLeaderUpdate)(r);i.valid||(0,security_1.throwValidationError)(i);null==a||a.step("Fetching leader profile");const o=await db_1.models.copyTradingLeader.findOne({where:{userId:t.id}});if(!o)throw(0,error_1.createError)({statusCode:404,message:"You are not a leader"});if("ACTIVE"!==o.status)throw(0,error_1.createError)({statusCode:400,message:"Only active leaders can update their profile"});const s={},d={},n=["displayName","bio","tradingStyle","riskLevel","profitSharePercent","minFollowAmount","maxFollowers","isPublic"];for(const e of n)if(void 0!==i.sanitized[e]){d[e]=o[e];s[e]=i.sanitized[e]}if(void 0!==r.avatar){d.avatar=o.avatar;s.avatar=r.avatar}null==a||a.step("Checking constraints");if(void 0!==s.maxFollowers){const e=await db_1.models.copyTradingFollower.count({where:{leaderId:o.id,status:"ACTIVE"}});if(s.maxFollowers<e)throw(0,error_1.createError)({statusCode:400,message:`Cannot set max followers below current count (${e})`})}null==a||a.step("Updating leader profile");await o.update(s);await(0,utils_1.createAuditLog)({entityType:"LEADER",entityId:o.id,action:"UPDATE",oldValue:d,newValue:s,userId:t.id});null==a||a.success("Leader profile updated");return{message:"Profile updated successfully",leader:o.toJSON()}};