"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),stats_calculator_1=require("@b/api/(ext)/copy-trading/utils/stats-calculator");exports.metadata={summary:"Get Available Copy Trading Leaders",description:"Retrieves all active public leaders available for copy trading.",operationId:"getCopyTradingLeaders",tags:["Copy Trading","Leaders"],requiresAuth:!1,logModule:"COPY",logTitle:"Get leaders list",parameters:[{name:"tradingStyle",in:"query",required:!1,schema:{type:"string",enum:["SCALPING","DAY_TRADING","SWING","POSITION"]},description:"Filter by trading style"},{name:"riskLevel",in:"query",required:!1,schema:{type:"string",enum:["LOW","MEDIUM","HIGH"]},description:"Filter by risk level"},{name:"minWinRate",in:"query",required:!1,schema:{type:"number"},description:"Minimum win rate filter"},{name:"minRoi",in:"query",required:!1,schema:{type:"number"},description:"Minimum ROI filter"},{name:"sortBy",in:"query",required:!1,schema:{type:"string",enum:["roi","winRate","totalFollowers","totalProfit"]},description:"Sort field"},{name:"sortOrder",in:"query",required:!1,schema:{type:"string",enum:["asc","desc"]},description:"Sort order"},{name:"page",in:"query",required:!1,schema:{type:"number"},description:"Page number"},{name:"limit",in:"query",required:!1,schema:{type:"number"},description:"Items per page"}],responses:{200:{description:"Leaders retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}},pagination:{type:"object",properties:{total:{type:"number"},page:{type:"number"},limit:{type:"number"},totalPages:{type:"number"}}}}}}}},500:{description:"Internal Server Error"}}};exports.default=async e=>{var t;const{query:r,user:i,ctx:a}=e;null==a||a.step("Fetching leaders");const s={status:"ACTIVE",isPublic:!0};r.tradingStyle&&(s.tradingStyle=r.tradingStyle);r.riskLevel&&(s.riskLevel=r.riskLevel);const l=r.minWinRate?parseFloat(r.minWinRate):null,n=r.minRoi?parseFloat(r.minRoi):null,o=parseInt(r.page)||1,d=Math.min(parseInt(r.limit)||20,100),u=r.sortBy||"roi",p="ASC"===(null===(t=r.sortOrder)||void 0===t?void 0:t.toUpperCase())?"ASC":"DESC",c=await db_1.models.copyTradingLeader.findAll({where:s,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]});null==a||a.step("Calculating stats for leaders");const m=c.map(e=>e.id),y=await(0,stats_calculator_1.calculateBatchLeaderStats)(m);let g=c.map(e=>{const t=y.get(e.id)||{totalFollowers:0,totalTrades:0,winRate:0,totalProfit:0,totalVolume:0,roi:0};return{...e.toJSON(),...t}});null!==l&&(g=g.filter(e=>e.winRate>=l));null!==n&&(g=g.filter(e=>e.roi>=n));g.sort((e,t)=>{const r=e[u]||0,i=t[u]||0;return"ASC"===p?r-i:i-r});const b=g.length,q=(o-1)*d,h=g.slice(q,q+d);null==a||a.step("Checking user follows");let v={};if(null==i?void 0:i.id){const e=await db_1.models.copyTradingFollower.findAll({where:{userId:i.id,leaderId:h.map(e=>e.id),status:{[sequelize_1.Op.ne]:"STOPPED"}},attributes:["leaderId"]});v=e.reduce((e,t)=>{e[t.leaderId]=!0;return e},{})}const I=h.map(e=>({...e,isFollowing:v[e.id]||!1}));null==a||a.success(`Found ${b} leaders`);return{items:I,pagination:{total:b,page:o,limit:d,totalPages:Math.ceil(b/d)}}};