"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("../../utils");exports.metadata={summary:"Check Leader Eligibility",description:"Checks if the current user is eligible to become a copy trading leader.",operationId:"checkCopyTradingLeaderEligibility",tags:["Copy Trading","Leaders"],requiresAuth:!0,logModule:"COPY",logTitle:"Check leader eligibility",responses:{200:{description:"Eligibility check completed",content:{"application/json":{schema:{type:"object",properties:{isEligible:{type:"boolean"},requirements:{type:"object",properties:{minTrades:{type:"object",properties:{required:{type:"number"},current:{type:"number"},met:{type:"boolean"}}},minWinRate:{type:"object",properties:{required:{type:"number"},current:{type:"number"},met:{type:"boolean"}}},accountAge:{type:"object",properties:{required:{type:"number"},current:{type:"number"},met:{type:"boolean"}}},kycVerified:{type:"object",properties:{required:{type:"boolean"},current:{type:"boolean"},met:{type:"boolean"}}}}},existingApplication:{type:"object",nullable:!0},blockedReason:{type:"string",nullable:!0}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{var t,r;const{user:i,ctx:n}=e;if(!(null==i?void 0:i.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==n||n.step("Fetching settings and existing application");const a=await(0,utils_1.getCopyTradingSettings)(),o=await db_1.models.copyTradingLeader.findOne({where:{userId:i.id}});let s=null;if(o)switch(o.status){case"ACTIVE":s="You are already an active leader";break;case"PENDING":s="Your leader application is pending review";break;case"SUSPENDED":s="Your leader account has been suspended"}null==n||n.step("Checking user requirements");const d=await db_1.models.user.findByPk(i.id);if(!d)throw(0,error_1.createError)({statusCode:404,message:"User not found"});const c=new Date(d.createdAt),l=new Date,u=Math.floor((l.getTime()-c.getTime())/864e5),p=((null===(t=d.kyc)||void 0===t?void 0:t.level)||0)>=2;let m=0,b=0;try{const e=await(null===(r=db_1.models.exchangeOrder)||void 0===r?void 0:r.findAll({where:{userId:i.id,status:"CLOSED"},attributes:["id","profit"]}));if(e&&e.length>0){m=e.length;b=e.filter(e=>(e.profit||0)>0).length/m*100}}catch(e){}const y={minTrades:{required:a.minLeaderTrades,current:m,met:m>=a.minLeaderTrades},minWinRate:{required:a.minLeaderWinRate,current:Math.round(100*b)/100,met:b>=a.minLeaderWinRate||0===m},accountAge:{required:a.minLeaderAccountAge,current:u,met:u>=a.minLeaderAccountAge},kycVerified:{required:a.requireKYC,current:p,met:!a.requireKYC||p}},g=!s&&y.minTrades.met&&y.minWinRate.met&&y.accountAge.met&&y.kycVerified.met;null==n||n.success("Eligibility checked");return{isEligible:g,requirements:y,existingApplication:o?{id:o.id,status:o.status,createdAt:o.createdAt,rejectionReason:o.rejectionReason}:null,blockedReason:s}};