"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("@b/api/(ext)/copy-trading/utils"),security_1=require("@b/api/(ext)/copy-trading/utils/security");exports.metadata={summary:"Apply to Become a Copy Trading Leader",description:"Submit an application to become a copy trading leader. Requires approval from admin.",operationId:"applyToBecomeLeader",tags:["Copy Trading","Leaders"],requiresAuth:!0,logModule:"COPY",logTitle:"Apply as leader",middleware:["copyTradingLeaderApply"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{displayName:{type:"string",minLength:2,maxLength:100,description:"Public display name"},bio:{type:"string",maxLength:1e3,description:"Short biography"},tradingStyle:{type:"string",enum:["SCALPING","DAY_TRADING","SWING","POSITION"],description:"Primary trading style"},riskLevel:{type:"string",enum:["LOW","MEDIUM","HIGH"],description:"Risk level of trading strategy"},profitSharePercent:{type:"number",minimum:0,maximum:50,description:"Percentage of profit to share with leader"},applicationNote:{type:"string",maxLength:2e3,description:"Additional notes for the application"},markets:{type:"array",items:{type:"object",properties:{symbol:{type:"string"},minBase:{type:"number",minimum:0},minQuote:{type:"number",minimum:0}},required:["symbol"]},minItems:1,description:"Array of market objects with symbol and optional min allocations"}},required:["displayName","tradingStyle","riskLevel","markets"]}}}},responses:{200:{description:"Application submitted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},leader:{type:"object"}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},429:{description:"Too Many Requests"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,body:i,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Validating application");const a=(0,security_1.validateLeaderApplication)(i);a.valid||(0,security_1.throwValidationError)(a);const{displayName:o,bio:s,tradingStyle:n,riskLevel:l,profitSharePercent:d=10,applicationNote:p}=a.sanitized,{markets:c}=i;if(!c||!Array.isArray(c)||0===c.length)throw(0,error_1.createError)({statusCode:400,message:"At least one trading market is required"});null==r||r.step("Validating markets");const u=[];for(const e of c){const t="string"==typeof e?e:e.symbol,i="object"==typeof e&&e.minBase||0,r="object"==typeof e&&e.minQuote||0;if("string"!=typeof t)throw(0,error_1.createError)({statusCode:400,message:"Invalid market symbol format"});const a=t.split("/");if(2!==a.length)throw(0,error_1.createError)({statusCode:400,message:`Invalid symbol format: ${t}. Use BASE/QUOTE (e.g., BTC/USDT)`});const[o,s]=a;if(!await db_1.models.ecosystemMarket.findOne({where:{currency:o,pair:s,status:!0}}))throw(0,error_1.createError)({statusCode:400,message:`Invalid or inactive market: ${t}`});u.push({symbol:t,baseCurrency:o,quoteCurrency:s,minBase:i,minQuote:r})}null==r||r.step("Checking eligibility");const m=await(0,utils_1.checkLeaderEligibility)(t.id);if(!m.eligible)throw(0,error_1.createError)({statusCode:400,message:m.reason||"Eligibility check failed"});null==r||r.step("Checking existing application");const y=await db_1.models.copyTradingLeader.findOne({where:{userId:t.id},paranoid:!1});null==r||r.step("Checking auto-approve setting");const g=await db_1.models.settings.findOne({where:{key:"copyTradingAutoApproveLeaders"}}),b="true"===(null==g?void 0:g.value)||!0===(null==g?void 0:g.value);null==r||r.step("Creating application");const f=await db_1.sequelize.transaction();try{let e;if(y&&"REJECTED"===y.status){e=await y.update({displayName:o,bio:s,tradingStyle:n,riskLevel:l,profitSharePercent:d,applicationNote:p,status:b?"ACTIVE":"PENDING",rejectionReason:null,deletedAt:null},{transaction:f});await db_1.models.copyTradingLeaderMarket.destroy({where:{leaderId:e.id},transaction:f})}else{if(y)throw(0,error_1.createError)({statusCode:400,message:"You already have an active leader application"});e=await db_1.models.copyTradingLeader.create({userId:t.id,displayName:o,bio:s,tradingStyle:n,riskLevel:l,profitSharePercent:d,maxFollowers:100,applicationNote:p,status:b?"ACTIVE":"PENDING",isPublic:!0},{transaction:f})}null==r||r.step("Creating leader markets");for(const t of u)await db_1.models.copyTradingLeaderMarket.create({leaderId:e.id,symbol:t.symbol,baseCurrency:t.baseCurrency,quoteCurrency:t.quoteCurrency,minBase:t.minBase,minQuote:t.minQuote,isActive:!0},{transaction:f});await(0,utils_1.createAuditLog)({entityType:"LEADER",entityId:e.id,action:"CREATE",newValue:{...e.toJSON(),markets:u},userId:t.id},f);await f.commit();null==r||r.step("Sending application notification");b?await(0,utils_1.notifyLeaderApplicationEvent)(t.id,e.id,"APPROVED",void 0,r):await(0,utils_1.notifyLeaderApplicationEvent)(t.id,e.id,"APPLIED",void 0,r);b||await(0,utils_1.notifyCopyTradingAdmins)("LEADER_APPLICATION",{leaderId:e.id,userName:`${t.firstName} ${t.lastName}`},r);null==r||r.success(b?"Application auto-approved":"Application submitted");return{message:b?"Application approved successfully. You can now accept followers.":"Application submitted successfully. Pending admin approval.",leader:{...e.toJSON(),markets:u}}}catch(e){await f.rollback();throw e}};