"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/currency/utils"),stats_calculator_1=require("@b/api/(ext)/copy-trading/utils/stats-calculator");exports.metadata={summary:"Get My Copy Trading Subscriptions",description:"Retrieves all leaders the current user is following.",operationId:"getMyCopyTradingSubscriptions",tags:["Copy Trading","Followers"],requiresAuth:!0,logModule:"COPY",logTitle:"Get my subscriptions",parameters:[{name:"status",in:"query",required:!1,schema:{type:"string",enum:["ACTIVE","PAUSED","STOPPED"]},description:"Filter by subscription status"}],responses:{200:{description:"Subscriptions retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object"}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:s,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching subscriptions");const o={userId:t.id};s.status?o.status=s.status:o.status={[sequelize_1.Op.ne]:"STOPPED"};const a=await db_1.models.copyTradingFollower.findAll({where:o,include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]},{model:db_1.models.copyTradingFollowerAllocation,as:"allocations"}],order:[["createdAt","DESC"]]});null==r||r.step("Calculating stats and USDT totals for each subscription");const i=await Promise.all(a.map(async e=>{const t=e.toJSON();let s=0;if(t.allocations&&t.allocations.length>0)for(const e of t.allocations)if(e.isActive)try{const[t,r]=e.symbol.split("/"),o=await(0,utils_1.getEcoPriceInUSD)(t),a=parseFloat(e.baseAmount||0)*o,i=await(0,utils_1.getEcoPriceInUSD)(r);s+=a+parseFloat(e.quoteAmount||0)*i}catch(t){console.error(`Failed to get price for ${e.symbol}:`,t)}const r=await(0,stats_calculator_1.getFollowerStats)(t.id);return{...t,totalAllocatedUSDT:Math.round(100*s)/100,...r}}));null==r||r.success(`Found ${a.length} subscriptions`);return i};