"use strict";async function processAiInvestments(){const t="processAiInvestments",e=Date.now();try{(0,broadcast_1.broadcastStatus)(t,"running");(0,broadcast_1.broadcastLog)(t,"Starting AI investments processing");const s=await getActiveInvestments(),a=s.length;(0,broadcast_1.broadcastLog)(t,`Found ${a} active AI investments`);for(let e=0;e<a;e++){const n=s[e];(0,broadcast_1.broadcastLog)(t,`Processing AI investment id ${n.id} (current status: ${n.status})`);try{await processAiInvestment(n)?(0,broadcast_1.broadcastLog)(t,`Successfully processed AI investment id ${n.id}`,"success"):(0,broadcast_1.broadcastLog)(t,`No update for AI investment id ${n.id}`,"warning")}catch(e){console_1.logger.error("AI_INVESTMENT_PROCESS",`Error processing investment ${n.id}: ${e.message}`,e);(0,broadcast_1.broadcastLog)(t,`Error processing AI investment id ${n.id}: ${e.message}`,"error");continue}const r=Math.round((e+1)/a*100);(0,broadcast_1.broadcastProgress)(t,r)}(0,broadcast_1.broadcastStatus)(t,"completed",{duration:Date.now()-e});(0,broadcast_1.broadcastLog)(t,"AI investments processing completed","success")}catch(e){console_1.logger.error("AI_INVESTMENT_PROCESS",`AI investments processing failed: ${e.message}`,e);(0,broadcast_1.broadcastStatus)(t,"failed");(0,broadcast_1.broadcastLog)(t,`AI investments processing failed: ${e.message}`,"error");throw e}}async function getActiveInvestments(){try{return await db_1.models.aiInvestment.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.aiInvestmentPlan,as:"plan",attributes:["id","name","title","description","profitPercentage","defaultProfit","defaultResult"]},{model:db_1.models.aiInvestmentDuration,as:"duration",attributes:["id","duration","timeframe"]}],order:[["status","ASC"],["createdAt","ASC"]]})}catch(t){console_1.logger.error("AI_INVESTMENT_PROCESS","Failed to get active investments",t);throw t}}async function processAiInvestment(t){var e,s,a;const n="processAiInvestments";try{if("COMPLETED"===t.status){(0,broadcast_1.broadcastLog)(n,`Investment ${t.id} is already COMPLETED; skipping`,"info");return null}(0,broadcast_1.broadcastLog)(n,`Fetching user for AI investment ${t.id}`);const r=await db_1.models.user.findByPk(t.userId);if(!r){(0,broadcast_1.broadcastLog)(n,`User not found for AI investment ${t.id}`,"error");return null}const o=null!==(e=t.amount)&&void 0!==e?e:0,i=null!==(s=t.plan.defaultProfit)&&void 0!==s?s:0,d=null!==(a=t.profit)&&void 0!==a?a:o*i/100;(0,broadcast_1.broadcastLog)(n,`Calculated ROI: ${d} for AI investment ${t.id}`);const c=t.result||t.plan.defaultResult;(0,broadcast_1.broadcastLog)(n,`Determined result (${c}) for AI investment ${t.id}`);const l=calculateEndDate(t);if((0,date_fns_1.isPast)(l)){(0,broadcast_1.broadcastLog)(n,`AI investment ${t.id} is eligible for processing (end date passed)`);const e=await handleAiInvestmentUpdate(t,r,d,c);e&&await postProcessAiInvestment(r,t,e);return e}(0,broadcast_1.broadcastLog)(n,`AI investment ${t.id} is not ready (end date not reached)`,"info");return null}catch(e){console_1.logger.error("AI_INVESTMENT_PROCESS",`General error processing AI investment ${t.id}: ${e.message}`,e);(0,broadcast_1.broadcastLog)(n,`General error processing AI investment ${t.id}: ${e.message}`,"error");throw e}}function calculateEndDate(t){const e=new Date(t.createdAt);switch(t.duration.timeframe){case"HOUR":default:return(0,date_fns_1.addHours)(e,t.duration.duration);case"DAY":return(0,date_fns_1.addDays)(e,t.duration.duration);case"WEEK":return(0,date_fns_1.addDays)(e,7*t.duration.duration);case"MONTH":return(0,date_fns_1.addDays)(e,30*t.duration.duration)}}async function handleAiInvestmentUpdate(t,e,s,a){var n;const r="processAiInvestments";let o;const i=await db_1.sequelize.transaction();try{(0,broadcast_1.broadcastLog)(r,`Starting update for AI investment ${t.id}`);const d=await(0,index_get_1.getTransactionByRefId)(t.id);if(!d){(0,broadcast_1.broadcastLog)(r,`Transaction not found for AI investment ${t.id}, removing investment`,"error");await db_1.models.aiInvestment.destroy({where:{id:t.id},transaction:i});await i.commit();return null}const c=await(0,utils_1.getWalletById)(d.walletId);if(!c){(0,broadcast_1.broadcastLog)(r,`Wallet not found for user ${e.id} (AI investment ${t.id})`,"error");await i.rollback();return null}const l=null!==(n=t.amount)&&void 0!==n?n:0;let u=0;if("WIN"===a)u=l+s;else if("LOSS"===a){u=l-s;u<0&&(u=0)}else u=l;(0,broadcast_1.broadcastLog)(r,`Calculated payout: ${u} for AI investment ${t.id}`);if(u>0){const e=`ai_invest_payout_${t.id}`;await wallet_1.walletService.credit({idempotencyKey:e,userId:c.userId,walletId:c.id,walletType:c.type,currency:c.currency,amount:u,operationType:"AI_INVESTMENT_ROI",referenceId:`${t.id}_roi`,description:`AI Investment ${a}: Plan "${t.plan.title}" | Duration: ${t.duration.duration} ${t.duration.timeframe}`,metadata:{investmentId:t.id,planId:t.planId,result:a,roi:s,originalAmount:l},transaction:i});(0,broadcast_1.broadcastLog)(r,`Wallet credited ${u} for AI investment ${t.id}`)}else(0,broadcast_1.broadcastLog)(r,`No payout for AI investment ${t.id} (total loss)`);await db_1.models.aiInvestment.update({status:"COMPLETED",result:a,profit:s},{where:{id:t.id},transaction:i});(0,broadcast_1.broadcastLog)(r,`AI investment ${t.id} updated to COMPLETED (${a})`);o=await db_1.models.aiInvestment.findByPk(t.id,{include:[{model:db_1.models.aiInvestmentPlan,as:"plan"},{model:db_1.models.aiInvestmentDuration,as:"duration"}],transaction:i});await i.commit();(0,broadcast_1.broadcastLog)(r,`Transaction committed for AI investment ${t.id}`,"success")}catch(e){await i.rollback();(0,broadcast_1.broadcastLog)(r,`Error updating AI investment ${t.id}: ${e.message}`,"error");console_1.logger.error("AI_INVESTMENT_UPDATE",`Error updating AI investment: ${e.message}`,e);return null}return o}async function postProcessAiInvestment(t,e,s){var a;const n="processAiInvestments";try{(0,broadcast_1.broadcastLog)(n,`Sending AI investment email for investment ${e.id}`);await(0,emails_1.sendAiInvestmentEmail)(t,e.plan,e.duration,s,"AiInvestmentCompleted");(0,broadcast_1.broadcastLog)(n,`AI investment email sent for investment ${e.id}`,"success");(0,broadcast_1.broadcastLog)(n,`Creating notification for AI investment ${e.id}`);await(0,notifications_1.createNotification)({userId:t.id,relatedId:s.id,title:"AI Investment Completed",message:`Your AI investment of ${e.amount} ${e.symbol} has been completed with a status of ${s.result}`,type:"system",link:`/ai/investments/${s.id}`,actions:[{label:"View Investment",link:`/ai/investments/${s.id}`,primary:!0}]});(0,broadcast_1.broadcastLog)(n,`Notification created for AI investment ${e.id}`,"success");(0,broadcast_1.broadcastLog)(n,`Processing rewards for AI investment ${e.id}`);await(0,affiliate_1.processRewards)(t.id,null!==(a=e.amount)&&void 0!==a?a:0,"AI_INVESTMENT",e.symbol);(0,broadcast_1.broadcastLog)(n,`Rewards processed for AI investment ${e.id}`,"success")}catch(t){(0,broadcast_1.broadcastLog)(n,`Error in postProcessAiInvestment for ${e.id}: ${t.message}`,"error");console_1.logger.error("AI_INVESTMENT_POST_PROCESS",`Error in postProcessAiInvestment: ${t.message}`,t)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.processAiInvestments=processAiInvestments;exports.getActiveInvestments=getActiveInvestments;exports.processAiInvestment=processAiInvestment;const db_1=require("@b/db"),console_1=require("@b/utils/console"),date_fns_1=require("date-fns"),index_get_1=require("@b/api/finance/transaction/[id]/index.get"),utils_1=require("@b/api/finance/wallet/utils"),emails_1=require("@b/utils/emails"),notifications_1=require("@b/utils/notifications"),affiliate_1=require("@b/utils/affiliate"),broadcast_1=require("@b/cron/broadcast"),wallet_1=require("@b/services/wallet");