"use strict";async function getMlmSystemAndSettings(){const e=cache_1.CacheManager.getInstance(),r=await e.getSettings(),t=r.get("affiliateMlmSystem")||r.get("mlmSystem")||"DIRECT",l={};if("BINARY"===t){const e=parseInt(r.get("affiliateBinaryLevels")||"2");if(e>=2&&e<=7){const t=[];for(let l=1;l<=e;l++){const e=parseFloat(r.get(`affiliateBinaryLevel${l}`)||"0");t.push({level:l,value:e})}l.binary={levels:e,levelsPercentage:t}}}else if("UNILEVEL"===t){const e=parseInt(r.get("affiliateUnilevelLevels")||"2");if(e>=2&&e<=7){const t=[];for(let l=1;l<=e;l++){const e=parseFloat(r.get(`affiliateUnilevelLevel${l}`)||"0");t.push({level:l,value:e})}l.unilevel={levels:e,levelsPercentage:t}}}return{mlmSystem:t,mlmSettings:l}}async function listDirectReferrals(e,r){var t,l,a,s,i,d,n;try{null===(t=null==r?void 0:r.step)||void 0===t||t.call(r,"Fetching direct referrals");const n=e.id,o=await db_1.models.mlmReferral.findAll({where:{referrerId:n},include:[{model:db_1.models.user,as:"referred",attributes:["id","firstName","lastName","avatar","createdAt","status"],include:[{model:db_1.models.mlmReferral,as:"referrerReferrals",attributes:["id"]}]},{model:db_1.models.user,as:"referrer",include:[{model:db_1.models.mlmReferralReward,as:"referralRewards",attributes:["id"]}]}]});null===(l=null==r?void 0:r.step)||void 0===l||l.call(r,"Processing referrals data");const u=o.map(e=>{var r,t,l,a,s,i,d,n;return{id:null===(r=e.referred)||void 0===r?void 0:r.id,firstName:null===(t=e.referred)||void 0===t?void 0:t.firstName,lastName:null===(l=e.referred)||void 0===l?void 0:l.lastName,avatar:null===(a=e.referred)||void 0===a?void 0:a.avatar,createdAt:null===(s=e.referred)||void 0===s?void 0:s.createdAt,status:null===(i=e.referred)||void 0===i?void 0:i.status,level:2,rewardsCount:0,referredCount:(null===(n=null===(d=e.referred)||void 0===d?void 0:d.referrerReferrals)||void 0===n?void 0:n.length)||0,downlines:[]}}),f=(null===(i=null===(s=null===(a=o[0])||void 0===a?void 0:a.referrer)||void 0===s?void 0:s.referralRewards)||void 0===i?void 0:i.length)||0,c={id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:f,referredCount:o.length,downlines:u};null===(d=null==r?void 0:r.success)||void 0===d||d.call(r,"Direct referrals fetched successfully");return c}catch(e){null===(n=null==r?void 0:r.fail)||void 0===n||n.call(r,e.message);throw e}}async function listUnilevelReferrals(e,r,t){var l,a,s,i,d,n;try{null===(l=null==t?void 0:t.step)||void 0===l||l.call(t,"Fetching unilevel referrals");const o=e.id;if(!(null===(a=null==r?void 0:r.unilevel)||void 0===a?void 0:a.levels)){null===(s=null==t?void 0:t.step)||void 0===s||s.call(t,"Unilevel settings not configured, returning empty structure");return{id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:0,referredCount:0,downlines:[]}}const u=e.referrerReferrals||[],f={id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:await db_1.models.mlmReferralReward.count({where:{referrerId:o}}),referredCount:u.length,downlines:[]},c=new Set([e.id]);async function m(e,l){var a,s;if(l>r.unilevel.levels||!e.length)return[];null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Building downlines for level ${l}`);const i=[];for(const r of e){const e=r.referred;if(c.has(e.id))continue;c.add(e.id);const t=await db_1.models.mlmReferral.findAll({where:{referrerId:e.id},include:[{model:db_1.models.user,as:"referred",attributes:["id","firstName","lastName","avatar","createdAt","status"],include:[{model:db_1.models.mlmReferralReward,as:"referralRewards",attributes:["id"]}]}],raw:!0,nest:!0}),a={id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:l,rewardsCount:(null===(s=e.referralRewards)||void 0===s?void 0:s.length)||0,referredCount:t.length,downlines:await m(t,l+1)};i.push(a)}return i}null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,"Building downline hierarchy");f.downlines=await m(u,2);null===(d=null==t?void 0:t.success)||void 0===d||d.call(t,"Unilevel referrals fetched successfully");return f}catch(v){null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,v.message);throw v}}async function listBinaryReferrals(e,r,t){var l,a,s,i,d,n,o,u;try{null===(l=null==t?void 0:t.step)||void 0===l||l.call(t,"Fetching binary referrals");const f=e.id;if(!(null===(a=null==r?void 0:r.binary)||void 0===a?void 0:a.levels)){null===(s=null==t?void 0:t.step)||void 0===s||s.call(t,"Binary settings not configured, returning empty structure");return{id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:0,referredCount:0,downlines:[]}}const c=await db_1.models.mlmReferral.findOne({where:{referrerId:f,referredId:f},attributes:["id"],raw:!0});if(!c){null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,"No self-referral found, returning empty structure");return{id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:0,referredCount:0,downlines:[]}}const m=await db_1.models.mlmBinaryNode.findOne({where:{referralId:c.id},attributes:["id"],raw:!0});if(!m){null===(d=null==t?void 0:t.step)||void 0===d||d.call(t,"No root node found, returning empty structure");return{id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:0,referredCount:0,downlines:[]}}const v=new Set([e.id]);async function w(e,l=2){var a,s,i;if(l>r.binary.levels||l>10)return[];null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Fetching binary downlines for level ${l}`);const d=await db_1.models.mlmBinaryNode.findAll({where:{parentId:{[sequelize_1.Op.in]:e}},include:[{model:db_1.models.mlmReferral,as:"referral",include:[{model:db_1.models.user,as:"referred",attributes:["id","firstName","lastName","avatar","createdAt","status"],include:[{model:db_1.models.mlmReferralReward,as:"referralRewards",attributes:["id"]},{model:db_1.models.mlmReferral,as:"referrerReferrals",attributes:["id"]}]}]},{model:db_1.models.mlmBinaryNode,as:"leftChild",attributes:["id"]},{model:db_1.models.mlmBinaryNode,as:"rightChild",attributes:["id"]}],raw:!0,nest:!0}),n=[];for(const e of d){const r=e.referral.referred;if(v.has(r.id))continue;v.add(r.id);const t=e.leftChild?await w([e.leftChild.id],l+1):[],a=e.rightChild?await w([e.rightChild.id],l+1):[];n.push({id:r.id,firstName:r.firstName,lastName:r.lastName,avatar:r.avatar,createdAt:r.createdAt,status:r.status,level:l,rewardsCount:(null===(s=r.referralRewards)||void 0===s?void 0:s.length)||0,referredCount:(null===(i=r.referrerReferrals)||void 0===i?void 0:i.length)||0,downlines:[...t,...a]})}return n}null===(n=null==t?void 0:t.step)||void 0===n||n.call(t,"Building binary tree structure");const h=await w([m.id],2),g=await db_1.models.mlmReferralReward.count({where:{referrerId:f}}),N={id:e.id,firstName:e.firstName,lastName:e.lastName,avatar:e.avatar,createdAt:e.createdAt,status:e.status,level:1,rewardsCount:g,referredCount:h.reduce((e,r)=>e+r.referredCount,0),downlines:h};null===(o=null==t?void 0:t.success)||void 0===o||o.call(t,"Binary referrals fetched successfully");return N}catch(b){null===(u=null==t?void 0:t.fail)||void 0===u||u.call(t,b.message);throw b}}Object.defineProperty(exports,"__esModule",{value:!0});exports.baseReferralSchema=void 0;exports.getMlmSystemAndSettings=getMlmSystemAndSettings;exports.listDirectReferrals=listDirectReferrals;exports.listUnilevelReferrals=listUnilevelReferrals;exports.listBinaryReferrals=listBinaryReferrals;const db_1=require("@b/db"),schema_1=require("@b/utils/schema"),sequelize_1=require("sequelize"),cache_1=require("@b/utils/cache");exports.baseReferralSchema={id:(0,schema_1.baseStringSchema)("Referral ID"),referredId:(0,schema_1.baseStringSchema)("Referred user UUID"),referrerId:(0,schema_1.baseStringSchema)("Referrer user UUID"),createdAt:(0,schema_1.baseStringSchema)("Date of referral")};