"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize");exports.metadata={summary:"Retrieves affiliate program statistics",description:"Fetches public statistics for the affiliate program including total affiliates, total paid out, average monthly earnings, and success rate.",operationId:"getAffiliateStats",tags:["Affiliate","Stats"],logModule:"AFFILIATE",logTitle:"Get Public Stats",responses:{200:{description:"Affiliate stats retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalAffiliates:{type:"number",description:"Total number of affiliates with referrals"},totalPaidOut:{type:"number",description:"Total amount paid out in rewards"},avgMonthlyEarnings:{type:"number",description:"Average monthly earnings per affiliate"},successRate:{type:"number",description:"Success rate percentage (active referrals / total referrals)"}},required:["totalAffiliates","totalPaidOut","avgMonthlyEarnings","successRate"]}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching Affiliate Program Stats");try{const[e,a,r,s,i]=await Promise.all([db_1.models.mlmReferral.count({distinct:!0,col:"referrerId"}),db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"total"]],raw:!0}),db_1.models.mlmReferral.count(),db_1.models.mlmReferral.count({where:{status:"ACTIVE"}}),db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("reward")),"avgReward"]],where:{createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-2592e6)}},raw:!0})]),l=parseFloat(null==a?void 0:a.total)||0,o=parseFloat(null==i?void 0:i.avgReward)||0,n=r>0?Math.round(s/r*100):0,u={totalAffiliates:e,totalPaidOut:Math.round(100*l)/100,avgMonthlyEarnings:Math.round(100*o)/100,successRate:n};null==t||t.success(`Stats fetched: ${u.totalAffiliates} affiliates, $${u.totalPaidOut} paid out`);return u}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error retrieving affiliate stats: ${e.message}`})}};