"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/(ext)/admin/affiliate/reward/utils"),db_1=require("@b/db"),constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Lists all MLM Referral Rewards with pagination and optional filtering",operationId:"listMlmReferralRewards",tags:["MLM","Referral Rewards"],parameters:constants_1.crudParameters,responses:{200:{description:"List of MLM Referral Rewards with pagination information",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.mlmReferralRewardSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("MLM Referral Rewards"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"AFFILIATE",logTitle:"List affiliate rewards"};exports.default=async e=>{var r;const{user:t,query:a,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==i||i.step("Fetching affiliate rewards with pagination and filtering");const s=await(0,query_1.getFiltered)({model:db_1.models.mlmReferralReward,query:a,where:{referrerId:t.id},sortField:a.sortField||"createdAt",includeModels:[{model:db_1.models.mlmReferralCondition,as:"condition",attributes:["title","rewardType","rewardWalletType","rewardCurrency","rewardChain"]}]});null==i||i.success(`Retrieved ${(null===(r=s.items)||void 0===r?void 0:r.length)||0} affiliate rewards`);return s};