"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const chart_1=require("@b/utils/chart"),db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Gets chart data for analytics",operationId:"getAnalyticsData",tags:["User","Analytics"],requiresAuth:!0,logModule:"AFFILIATE",logTitle:"Get affiliate analytics data",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{model:{type:"string"},timeframe:{type:"string"},db:{type:"string"},keyspace:{type:"string",nullable:!0},charts:{type:"array",items:{type:"object",properties:{id:{type:"string"},title:{type:"string"},type:{type:"string",enum:["line","bar","pie","stackedBar","stackedArea"]},model:{type:"string"},metrics:{type:"array",items:{type:"string"}}}}},kpis:{type:"array",items:{type:"object",properties:{id:{type:"string"},title:{type:"string"},metric:{type:"string"},model:{type:"string"},icon:{type:"string"}}}}},required:["model","timeframe","charts","kpis"]}}}},responses:{200:{description:"Analytics data object matching your shape (kpis + chart keys)",content:{"application/json":{schema:{type:"object",properties:{kpis:{type:"array",items:{type:"object",properties:{id:{type:"string"},title:{type:"string"},value:{type:"number"},change:{type:"number"},trend:{type:"array",items:{type:"object",properties:{date:{type:"string"},value:{type:"number"}}}},icon:{type:"string"}}}}},additionalProperties:!0}}}},401:{description:"Unauthorized access"}}};exports.default=async e=>{const{user:t,query:r,body:a,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{model:s,modelConfig:o,db:n="mysql",keyspace:l,timeframe:p,charts:d,kpis:c}=a,{availableFilters:y}=a;null==i||i.step(`Validating analytics request for model: ${s}`);if(!["mlmReferral","mlmReferralReward"].includes(s))throw(0,error_1.createError)(400,"Invalid model");if(!db_1.models[s])throw(0,error_1.createError)(400,"Invalid model");if(!s)throw(0,error_1.createError)(400,"Missing model parameter");const m=o||{};null==i||i.step(`Generating chart data for ${(null==d?void 0:d.length)||0} charts and ${(null==c?void 0:c.length)||0} KPIs`);if("mysql"===n){if(!db_1.models[s])throw(0,error_1.createError)(400,"Invalid or missing model");const e=await(0,chart_1.getChartData)({model:db_1.models[s],timeframe:p,charts:d,kpis:c,where:m});null==i||i.success(`Generated analytics data for ${s} with timeframe: ${p}`);return e}};