"use strict";async function handler(e){const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Loading MLM system settings from cache");const{mlmSystem:a,mlmSettings:i}=await(0,utils_1.getMlmSystemAndSettings)();null==r||r.step("Fetching user profile data");const s=await db_1.models.user.findByPk(t.id,{attributes:["id","firstName","lastName","avatar","status","createdAt"],raw:!0});if(!s)throw(0,error_1.createError)({statusCode:404,message:"User not found"});null==r||r.step("Building user profile");const l={id:s.id,firstName:s.firstName,lastName:s.lastName,avatar:s.avatar,status:s.status,joinDate:s.createdAt.toISOString()};null==r||r.step("Calculating total rewards");const n=await db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"totalRewards"]],where:{referrerId:t.id},raw:!0}),o=parseFloat(null==n?void 0:n.totalRewards)||0;null==r||r.step("Looking up upline referrer");let d=null;const u=await db_1.models.mlmReferral.findOne({where:{referredId:t.id},include:[{model:db_1.models.user,as:"referrer",attributes:["id","firstName","lastName","avatar","status","createdAt"]}],raw:!0,nest:!0});if(null==u?void 0:u.referrer){const v=u.referrer,N=parseFloat((await db_1.models.mlmReferralReward.count({where:{referrerId:v.id}})).toString()),h=await db_1.models.mlmReferral.count({where:{referrerId:v.id}});d={id:v.id,firstName:v.firstName,lastName:v.lastName,avatar:v.avatar,status:v.status,joinDate:v.createdAt.toISOString(),earnings:N,teamSize:h,performance:h>0?Math.round(N/h*100):0}}null==r||r.step(`Fetching ${a||"DIRECT"} network tree data`);let f;switch(a){case"BINARY":f=await(0,utils_1.listBinaryReferrals)(s,i,r);break;case"UNILEVEL":f=await(0,utils_1.listUnilevelReferrals)(s,i,r);break;default:f=await(0,utils_1.listDirectReferrals)(s,r)}null==r||r.step("Normalizing network tree structure");const m=function e(t,r=0,a=new Set){var i,s,l,n,o;if(r>50||a.has(t.id))return null;a.add(t.id);const d=t.joinDate||(t.createdAt?new Date(t.createdAt).toISOString():void 0),u=null!==(s=null!==(i=t.earnings)&&void 0!==i?i:t.rewardsCount)&&void 0!==s?s:0,f=null!==(n=null!==(l=t.teamSize)&&void 0!==l?l:t.referredCount)&&void 0!==n?n:(null===(o=t.downlines)||void 0===o?void 0:o.length)||0,m=f?Math.round(u/f*100):0,c=(t.downlines||[]).slice(0,1e3).map(t=>e(t,r+1,new Set(a))).filter(Boolean);return{id:t.id,firstName:t.firstName,lastName:t.lastName,avatar:t.avatar,status:t.status,joinDate:d,earnings:u,teamSize:f,performance:m,role:t.role||(0===r?"You":""),level:r,downlines:c}}(f,0);let c,w,p;"DIRECT"===a&&(c=m.downlines.map(e=>({id:e.id,referred:e,referrerId:t.id,status:e.status,createdAt:e.joinDate,earnings:e.earnings,teamSize:e.teamSize,performance:e.performance,downlines:e.downlines})));if("BINARY"===a){const[S,b]=m.downlines;w={left:S||null,right:b||null}}if("UNILEVEL"===a){const _={};function I(e,t=0){_[t]||(_[t]=[]);t>0&&_[t].push(e);e.downlines.forEach(e=>I(e,t+1))}I(m,0);p=Object.keys(_).map(e=>Number(e)).sort((e,t)=>e-t).filter(e=>e>0).map(e=>_[e])}const g={...l,earnings:o,teamSize:m.teamSize,performance:m.performance,role:"You"};null==r||r.success(`Retrieved ${a||"DIRECT"} network tree with ${m.teamSize||0} team members`);return{user:g,totalRewards:o,upline:d,referrals:c,binaryStructure:w,levels:p,treeData:m}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.default=handler;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),utils_1=require("@b/api/(ext)/affiliate/utils");exports.metadata={summary:"Get Affiliate Network Node",description:"Retrieves the current user's affiliate network data for client visualization.",operationId:"getAffiliateNetworkNode",tags:["Affiliate","Network"],requiresAuth:!0,logModule:"AFFILIATE",logTitle:"Get affiliate network tree",responses:{200:{description:"Network data retrieved successfully."},401:{description:"Unauthorized – login required."},404:{description:"User not found."},500:{description:"Internal Server Error"}}};