"use strict";function getConditionCategory(e){return{TRADE:"Trading",DEPOSIT:"Deposits",INVESTMENT:"Investments",AI_INVESTMENT:"Investments",FOREX_INVESTMENT:"Investments",STAKING:"Staking",STAKING_LOYALTY:"Staking",ICO_CONTRIBUTION:"ICO",ECOMMERCE_PURCHASE:"E-commerce",P2P_TRADE:"P2P Trading",BINARY_WIN:"Network"}[e]||"Other"}function getConditionIcon(e){return{TRADE:"LineChart",DEPOSIT:"DollarSign",INVESTMENT:"TrendingUp",AI_INVESTMENT:"Bot",FOREX_INVESTMENT:"Globe",STAKING:"Coins",STAKING_LOYALTY:"Coins",ICO_CONTRIBUTION:"Rocket",ECOMMERCE_PURCHASE:"ShoppingBag",P2P_TRADE:"Users",BINARY_WIN:"Network"}[e]||"Gift"}function getTimeAgo(e){const r=Math.floor((Date.now()-e.getTime())/1e3);if(r<60)return"just now";if(r<3600)return`${Math.floor(r/60)}m ago`;if(r<86400)return`${Math.floor(r/3600)}h ago`;const t=Math.floor(r/86400);if(1===t)return"1 day ago";if(t<30)return`${t} days ago`;const a=Math.floor(t/30);return 1===a?"1 month ago":`${a} months ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),cache_1=require("@b/utils/cache"),utils_1=require("@b/api/(ext)/affiliate/utils");exports.metadata={summary:"Get affiliate landing page data",description:"Retrieves comprehensive data for the affiliate landing page including stats, conditions, top affiliates, and recent activity.",operationId:"getAffiliateLanding",tags:["Affiliate","Landing"],logModule:"AFFILIATE",logTitle:"Get Landing Data",responses:{200:{description:"Affiliate landing page data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},conditions:{type:"array"},topAffiliates:{type:"array"},recentActivity:{type:"array"}}}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{var r;const{ctx:t}=e;null==t||t.step("Fetching Affiliate Landing Data");try{const e=new Date,a=new Date(e.getTime()-2592e6),[i,n,o,l,d,s,u,c,f]=await Promise.all([db_1.models.mlmReferral.count({distinct:!0,col:"referrerId"}),db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"total"]],raw:!0}),db_1.models.mlmReferral.count(),db_1.models.mlmReferral.count({where:{status:"ACTIVE"}}),db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"total"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT referrerId")),"uniqueAffiliates"]],where:{createdAt:{[sequelize_1.Op.gte]:a}},raw:!0}),db_1.models.mlmReferralCondition.findAll({where:{status:!0},order:[["type","ASC"],["reward","DESC"]]}),db_1.models.mlmReferralReward.findAll({attributes:["referrerId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"totalEarnings"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("mlmReferralReward.id")),"rewardCount"]],group:["referrerId"],order:[[(0,sequelize_1.literal)("totalEarnings"),"DESC"]],limit:5,include:[{model:db_1.models.user,as:"referrer",attributes:["id","avatar","createdAt"]}],raw:!1}),db_1.models.mlmReferralReward.findAll({where:{createdAt:{[sequelize_1.Op.gte]:a}},order:[["createdAt","DESC"]],limit:10,include:[{model:db_1.models.mlmReferralCondition,as:"condition",attributes:["type","name","rewardCurrency"]}]}),db_1.models.mlmReferral.findOne({attributes:[[(0,sequelize_1.literal)("COUNT(*) / NULLIF(COUNT(DISTINCT referrerId), 0)"),"avgReferrals"]],raw:!0})]),m=parseFloat(null==n?void 0:n.total)||0,g=parseFloat(null==d?void 0:d.total)||0,p=parseInt(null==d?void 0:d.uniqueAffiliates)||1,T=p>0?g/p:0,_=o>0?Math.round(l/o*100):0,E=parseFloat(null==f?void 0:f.avgReferrals)||0,I=u.length>0&&parseFloat(null===(r=u[0].dataValues)||void 0===r?void 0:r.totalEarnings)||0;null==t||t.step("Filtering conditions based on available extensions");const A=cache_1.CacheManager.getInstance(),w=await A.getExtensions(),y={STAKING_LOYALTY:"staking",P2P_TRADE:"p2p",AI_INVESTMENT:"ai_investment",ICO_CONTRIBUTION:"ico",FOREX_INVESTMENT:"forex",ECOMMERCE_PURCHASE:"ecommerce"},C=s.filter(e=>{const r=y[e.name];return!r||w.has(r)}).map(e=>({id:e.id,name:e.name,title:e.title,description:e.description,type:e.type,reward:e.reward,rewardType:e.rewardType,rewardCurrency:e.rewardCurrency,rewardWalletType:e.rewardWalletType,displayReward:"PERCENTAGE"===e.rewardType?`${e.reward}%`:`${e.reward} ${e.rewardCurrency}`,category:getConditionCategory(e.type),icon:getConditionIcon(e.type)})),v=u.map((e,r)=>{var t,a,i,n;const o=e.referrer||(null===(t=e.dataValues)||void 0===t?void 0:t.referrer),l=e.referrerId||(null===(a=e.dataValues)||void 0===a?void 0:a.referrerId);return{rank:r+1,avatar:(null==o?void 0:o.avatar)||null,displayName:`Affiliate #${String(l).slice(-4).toUpperCase()}`,totalEarnings:parseFloat(null===(i=e.dataValues)||void 0===i?void 0:i.totalEarnings)||0,rewardCount:parseInt(null===(n=e.dataValues)||void 0===n?void 0:n.rewardCount)||0,joinedAgo:(null==o?void 0:o.createdAt)?getTimeAgo(new Date(o.createdAt)):"Unknown"}}),N=c.slice(0,8).map(e=>{var r,t,a;return{type:"reward_earned",amount:e.reward,conditionType:(null===(r=e.condition)||void 0===r?void 0:r.type)||"UNKNOWN",conditionName:(null===(t=e.condition)||void 0===t?void 0:t.name)||"Reward",currency:(null===(a=e.condition)||void 0===a?void 0:a.rewardCurrency)||"USD",timeAgo:getTimeAgo(new Date(e.createdAt))}}),{mlmSystem:R}=await(0,utils_1.getMlmSystemAndSettings)();null==t||t.success("Affiliate landing data retrieved successfully");return{stats:{totalAffiliates:i,totalPaidOut:Math.round(100*m)/100,avgMonthlyEarnings:Math.round(100*T)/100,successRate:_,topEarning:Math.round(100*I)/100,avgReferrals:Math.round(10*E)/10},conditions:C,topAffiliates:v,recentActivity:N,mlmSystem:R}}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error retrieving affiliate landing data: ${e.message}`})}};