"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Staking Positions",description:"Retrieves all staking positions with optional filtering by pool ID and status.",operationId:"getStakingPositions",tags:["Staking","Admin","Positions"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get All Positions",parameters:[{index:0,name:"poolId",in:"query",required:!1,schema:{type:"string"},description:"Filter positions by pool ID"},{index:1,name:"status",in:"query",required:!1,schema:{type:"string",enum:["ACTIVE","COMPLETED","CANCELLED","PENDING_WITHDRAWAL"]},description:"Filter positions by status"}],responses:{200:{description:"Positions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"view.staking.position"};exports.default=async e=>{const{user:i,query:o,ctx:t}=e;if(!(null==i?void 0:i.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==t||t.step("Fetching data");const e={};(null==o?void 0:o.poolId)&&(e.poolId=o.poolId);(null==o?void 0:o.status)&&(e.status=o.status);const i=await db_1.models.stakingPosition.findAll({where:e,include:[{model:db_1.models.stakingPool,as:"pool"},{model:db_1.models.stakingEarningRecord,as:"earningHistory",required:!1}],order:[["createdAt","DESC"]]}),s=await Promise.all(i.map(async e=>{var i,o,t,s;const r=await db_1.models.stakingEarningRecord.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"pendingRewards"]],where:{positionId:e.id,isClaimed:!1},raw:!0}),n=(null==r?void 0:r.pendingRewards)||0,a=await db_1.models.stakingEarningRecord.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"earningsToDate"]],where:{positionId:e.id},raw:!0}),d=(null==a?void 0:a.earningsToDate)||0,l=await db_1.models.stakingEarningRecord.findOne({attributes:["createdAt"],where:{positionId:e.id},order:[["createdAt","DESC"]],raw:!0}),u=(null==l?void 0:l.createdAt)||null;return{...e.toJSON(),pendingRewards:n,earningsToDate:d,lastEarningDate:u,rewardTokenSymbol:null===(i=e.pool)||void 0===i?void 0:i.symbol,tokenSymbol:null===(o=e.pool)||void 0===o?void 0:o.symbol,poolName:null===(t=e.pool)||void 0===t?void 0:t.name,lockPeriodEnd:e.endDate,apr:null===(s=e.pool)||void 0===s?void 0:s.apr}}));null==t||t.success("Staking positions retrieved successfully");return s}catch(e){console.error("Error fetching staking positions:",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch staking positions"})}};