"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create External Pool Performance Record",operationId:"createExternalPoolPerformance",description:"Creates a new performance record for an external staking pool. Records daily or periodic performance metrics including APR achieved, total amount staked, profit generated, and operational notes. Used for tracking and analyzing external pool performance over time.",tags:["Admin","Staking","Performance"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Add Pool Performance",requestBody:{description:"External pool performance data",required:!0,content:{"application/json":{schema:{type:"object",properties:{poolId:{type:"string",format:"uuid",description:"ID of the staking pool"},date:{type:"string",format:"date-time",description:"Date of the performance record"},apr:{type:"number",minimum:0,description:"Annual Percentage Rate achieved"},totalStaked:{type:"number",minimum:0,description:"Total amount staked in the pool"},profit:{type:"number",description:"Profit generated (can be negative)"},notes:{type:"string",description:"Additional notes or observations"}},required:["poolId","date","apr","totalStaked","profit"]}}}},responses:{201:{description:"Performance record created successfully",content:{"application/json":{schema:{type:"object",properties:{...errors_1.commonFields,poolId:{type:"string",format:"uuid"},date:{type:"string",format:"date-time"},apr:{type:"number"},totalStaked:{type:"number"},profit:{type:"number"},notes:{type:"string"},pool:{type:"object",description:"Associated staking pool details"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Staking Pool"),500:errors_1.serverErrorResponse},permission:"create.staking.performance"};exports.default=async e=>{const{user:r,body:o,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});if(!o)throw(0,error_1.createError)({statusCode:400,message:"Request body is required"});const{poolId:a,date:n,apr:s,totalStaked:i,profit:d,notes:c=""}=o;if(!a||!n||void 0===s||void 0===i||void 0===d)throw(0,error_1.createError)({statusCode:400,message:"poolId, date, apr, totalStaked, and profit are required"});try{null==t||t.step("Check if pool exists");const e=await db_1.models.stakingPool.findByPk(a);if(!e)throw(0,error_1.createError)({statusCode:404,message:"Pool not found"});null==t||t.step("Create performance record");const o=await db_1.models.stakingExternalPoolPerformance.create({poolId:a,date:n,apr:s,totalStaked:i,profit:d,notes:c});null==t||t.step("Fetch created performance with pool");const p=await db_1.models.stakingExternalPoolPerformance.findOne({where:{id:o.id},include:[{model:db_1.models.stakingPool,as:"pool"}]});try{await(0,notifications_1.createNotification)({userId:r.id,relatedId:o.id,type:"system",title:"Pool Performance Added",message:`New performance record added for ${e.name} with ${s}% APR.`,details:"The performance record has been created successfully.",link:"/admin/staking/performance",actions:[{label:"View Performance",link:"/admin/staking/performance",primary:!0}]},t)}catch(e){console.error("Failed to create notification for performance record",e)}null==t||t.success("Pool performance record created successfully");return p}catch(e){if(404===e.statusCode)throw e;console.error("Error creating external pool performance:",e);throw(0,error_1.createError)({statusCode:500,message:e.message})}};