"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List External Pool Performance Records",operationId:"listExternalPoolPerformance",description:"Retrieves historical performance data for external staking pools. Performance records track daily metrics including APR, total staked amounts, profit, and notes. Can be filtered by specific pool and date range to analyze pool performance over time.",tags:["Admin","Staking","Performance"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get Staking Performance",parameters:[{index:0,name:"poolId",in:"query",required:!1,schema:{type:"string",format:"uuid"},description:"Filter performance records by pool ID"},{index:1,name:"startDate",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter performance records from this date onwards"},{index:2,name:"endDate",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter performance records up to this date"}],responses:{200:{description:"Performance data retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{...errors_1.commonFields,poolId:{type:"string",format:"uuid"},date:{type:"string",format:"date-time"},apr:{type:"number",description:"Annual Percentage Rate on this date"},totalStaked:{type:"number",description:"Total amount staked in the pool"},profit:{type:"number",description:"Profit generated on this date"},notes:{type:"string",description:"Additional notes about performance"},pool:{type:"object",description:"Associated staking pool details"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.staking.performance"};exports.default=async e=>{const{user:r,query:t,ctx:o}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==o||o.step("Fetching data");const e={};(null==t?void 0:t.poolId)&&(e.poolId=t.poolId);(null==t?void 0:t.startDate)&&(e.date={...e.date,[sequelize_1.Op.gte]:new Date(t.startDate)});(null==t?void 0:t.endDate)&&(e.date={...e.date,[sequelize_1.Op.lte]:new Date(t.endDate)});const r=await db_1.models.stakingExternalPoolPerformance.findAll({where:e,include:[{model:db_1.models.stakingPool,as:"pool"}],order:[["date","DESC"]]});null==o||o.success("Operation completed successfully");return r}catch(e){console.error("Error fetching external pool performance:",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch external pool performance"})}};