"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Distribute Earnings to Positions",operationId:"distributeStakingEarningsToPositions",description:"Manually distributes earnings to active staking positions based on APR and days active. Calculates daily earnings for each position, deducts platform fees, and creates earning records for both users and platform. Supports dry-run mode for testing and can process specific positions or all active positions in a pool. Includes safeguards against recent distributions unless forced.",tags:["Admin","Staking","Earnings"],logModule:"ADMIN_STAKE",logTitle:"Distribute Staking Earnings",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",required:["poolId"],properties:{poolId:{type:"string",format:"uuid",description:"Pool ID to distribute earnings for"},positionIds:{type:"array",description:"Specific position IDs to process (optional, processes all active if not provided)",items:{type:"string",format:"uuid"}},dryRun:{type:"boolean",description:"If true, simulates the distribution without making changes",default:!1},forceProcess:{type:"boolean",description:"If true, processes even if recently processed",default:!1}}}}}},responses:{200:{description:"Earnings distributed successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},processed:{type:"integer",description:"Number of positions processed"},totalEarnings:{type:"number",description:"Total gross earnings calculated"},platformFees:{type:"number",description:"Total platform fees collected"},netEarnings:{type:"number",description:"Net earnings distributed to users"},dryRun:{type:"boolean",description:"Whether this was a simulation"},details:{type:"array",description:"Detailed breakdown (only included in dry-run mode)",items:{type:"object",properties:{positionId:{type:"string"},userId:{type:"string"},amount:{type:"number"},earnings:{type:"number"},platformFee:{type:"number"},netEarning:{type:"number"}}}}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,404:(0,errors_1.notFoundResponse)("Staking Pool"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"access.staking.management"};exports.default=async e=>{const{user:t,body:s,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{poolId:o,positionIds:i,dryRun:n=!1,forceProcess:a=!1}=s;if(!o||"string"!=typeof o)throw(0,error_1.createError)({statusCode:400,message:"Valid pool ID is required"});if(i&&(!Array.isArray(i)||0===i.length))throw(0,error_1.createError)({statusCode:400,message:"positionIds must be a non-empty array if provided"});if(i&&i.length>100)throw(0,error_1.createError)({statusCode:400,message:"Maximum 100 positions can be processed at once"});const d=n?null:await db_1.sequelize.transaction();try{null==r||r.step("Fetch staking pool");const e=await db_1.models.stakingPool.findByPk(o,{transaction:d});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Staking pool not found"});if("ACTIVE"!==e.status&&!a)throw(0,error_1.createError)({statusCode:400,message:"Pool is not active. Use forceProcess=true to override."});const s={poolId:o,status:"ACTIVE"};i&&(s.id={[sequelize_1.Op.in]:i});null==r||r.step("Check if recently processed");if(!a){const e=new Date;e.setHours(e.getHours()-1);if(await db_1.models.stakingEarningRecord.findOne({include:[{model:db_1.models.stakingPosition,as:"position",where:s,attributes:[]}],where:{createdAt:{[sequelize_1.Op.gte]:e}},transaction:d}))throw(0,error_1.createError)({statusCode:400,message:"Earnings were recently distributed for this pool. Use forceProcess=true to override."})}null==r||r.step("Fetch positions to process");const u=await db_1.models.stakingPosition.findAll({where:s,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email"]}],transaction:d});if(0===u.length)throw(0,error_1.createError)({statusCode:404,message:"No active positions found to process"});null==r||r.step("Calculate and distribute earnings");const c=new Date;let l=0,p=0;const g=[];for(const s of u){const r=new Date(s.startDate),o=Math.floor((c.getTime()-r.getTime())/864e5);if(o<=0)continue;const i=e.apr/365/100,a=s.amount*i*o,u=e.platformFeePercentage||10,m=a*u/100,f=a-m;l+=a;p+=m;g.push({positionId:s.id,userId:s.userId,amount:s.amount,earnings:Math.round(100*a)/100,platformFee:Math.round(100*m)/100,netEarning:Math.round(100*f)/100});if(!n&&f>0){await db_1.models.stakingEarningRecord.create({positionId:s.id,amount:f,type:"REWARD",isClaimed:!1,metadata:{daysActive:o,dailyRate:i,apr:e.apr,distributedBy:t.id,distributionType:"MANUAL"}},{transaction:d});m>0&&await db_1.models.stakingAdminEarning.create({poolId:e.id,amount:m,type:"PLATFORM_FEE",source:"MANUAL_DISTRIBUTION",metadata:{positionId:s.id,userId:s.userId,grossEarnings:a,feePercentage:u}},{transaction:d})}}null==r||r.step("Create admin activity log");n||await db_1.models.stakingAdminActivity.create({userId:t.id,action:"distribute_earnings",type:"earnings",relatedId:o,metadata:{poolId:o,positionCount:u.length,totalEarnings:Math.round(100*l)/100,platformFees:Math.round(100*p)/100,netEarnings:Math.round(100*(l-p))/100,positionIds:u.map(e=>e.id)}},{transaction:d});d&&await d.commit();null==r||r.success(n?"Dry run completed successfully":"Earnings distributed successfully");return{message:n?"Dry run completed - no changes made":"Earnings distributed successfully",processed:g.length,totalEarnings:Math.round(100*l)/100,platformFees:Math.round(100*p)/100,netEarnings:Math.round(100*(l-p))/100,dryRun:n,details:n?g:void 0}}catch(e){d&&await d.rollback();if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to distribute earnings"})}};