"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Distribute Earnings to Stakers",operationId:"distributeStakingEarnings",description:"Distributes earnings to all active stakers in a pool. The total amount is split into admin fees (based on pool's adminFeePercentage) and user earnings. Admin fees are recorded as a PLATFORM_FEE admin earning. User earnings are distributed proportionally to each active position based on their staked amount. Creates earning records for both admin and users, and logs the distribution activity.",tags:["Admin","Staking","Earnings"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Distribute Earnings",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{poolId:{type:"string",format:"uuid",description:"ID of the staking pool to distribute earnings for"},amount:{type:"number",minimum:0,description:"Total amount to distribute (before admin fee)"},distributionType:{type:"string",enum:["regular","bonus"],description:"Type of distribution: 'regular' for standard earnings or 'bonus' for extra rewards"}},required:["poolId","amount","distributionType"]}}}},responses:{200:(0,errors_1.successMessageResponse)("Earnings distributed successfully to all active stakers"),400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Staking Pool"),500:errors_1.serverErrorResponse},permission:"create.staking.earning"};exports.default=async e=>{const{user:t,body:r,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{poolId:s,amount:o,distributionType:n}=r;if(!s||!o||!n)throw(0,error_1.createError)({statusCode:400,message:"poolId, amount, and distributionType are required"});if(!["regular","bonus"].includes(n))throw(0,error_1.createError)({statusCode:400,message:"Invalid distributionType"});const a=await db_1.sequelize.transaction();try{null==i||i.step("Fetch pool");const e=await db_1.models.stakingPool.findByPk(s,{transaction:a});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Pool not found"});null==i||i.step("Calculate admin fee and user earnings");const r=parseFloat((o*e.adminFeePercentage/100).toFixed(4)),d=parseFloat((o-r).toFixed(4));null==i||i.step("Create admin earning record");await db_1.models.stakingAdminEarning.create({poolId:e.id,amount:r,type:"PLATFORM_FEE",currency:e.symbol,isClaimed:!1},{transaction:a});null==i||i.step("Get active staking positions");const u=await db_1.models.stakingPosition.findAll({where:{poolId:e.id,status:"ACTIVE"},transaction:a}),l=u.reduce((e,t)=>e+t.amount,0);if(0===l)throw(0,error_1.createError)({statusCode:400,message:"No active positions found for distribution"});null==i||i.step("Distribute earnings to positions");const c=n.toUpperCase();for(const t of u){const r=t.amount/l,i=parseFloat((d*r).toFixed(4));i>0&&await db_1.models.stakingEarningRecord.create({positionId:t.id,amount:i,type:c,description:`Earnings distribution from pool ${e.name}`,isClaimed:!1},{transaction:a})}null==i||i.step("Log distribution activity");await db_1.models.stakingAdminActivity.create({userId:t.id,action:"distribute",type:"earnings",relatedId:e.id},{transaction:a});await a.commit();try{await(0,notifications_1.createNotification)({userId:t.id,relatedId:e.id,type:"system",title:"Earnings Distributed",message:`Distributed ${o} ${e.symbol}: Admin Fee ${r}, User Earnings ${d}`,details:"Earnings distribution completed successfully.",link:"/admin/staking/earnings",actions:[{label:"View Earnings",link:"/admin/staking/earnings",primary:!0}]},i)}catch(e){console.error("Failed to create notification",e)}null==i||i.success("Earnings distributed successfully");return{message:"Earnings distributed successfully"}}catch(e){await a.rollback();console.error("Error distributing earnings:",e);throw(0,error_1.createError)({statusCode:e.statusCode||500,message:e.message||"Failed to distribute earnings"})}};