"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Admin Activities",description:"Retrieves all admin activities with optional filtering by action, type, and search term (e.g. admin name or related ID).",operationId:"getAdminActivities",tags:["Staking","Admin","Activities"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get Staking Activities",parameters:[{index:0,name:"action",in:"query",required:!1,schema:{type:"string",enum:["create","update","delete","approve","reject","distribute"]},description:"Filter activities by action type"},{index:1,name:"type",in:"query",required:!1,schema:{type:"string",enum:["pool","position","earnings","settings","withdrawal"]},description:"Filter activities by activity type"},{index:2,name:"search",in:"query",required:!1,schema:{type:"string"},description:"Search term to filter activities by relatedId or admin details (first name, last name, email)"}],responses:{200:{description:"Admin activities retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"view.staking.activity",demoMask:["user.email"]};exports.default=async e=>{const{user:i,query:t,ctx:r}=e;if(!(null==i?void 0:i.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==r||r.step("Fetching data");const e={};(null==t?void 0:t.action)&&(e.action=t.action);(null==t?void 0:t.type)&&(e.type=t.type);let i;if(null==t?void 0:t.search){const r=`%${t.search}%`;i={[sequelize_1.Op.or]:[{firstName:{[sequelize_1.Op.like]:r}},{lastName:{[sequelize_1.Op.like]:r}},{email:{[sequelize_1.Op.like]:r}}]};e[sequelize_1.Op.or]=[{relatedId:{[sequelize_1.Op.like]:r}}]}const s=await db_1.models.stakingAdminActivity.findAll({where:e,include:[{model:db_1.models.user,as:"user",required:!1,...i?{where:i}:{},attributes:["id","firstName","lastName","email","avatar"]}],order:[["createdAt","DESC"]]});null==r||r.success("Operation completed successfully");return s}catch(e){console.error("Error fetching admin activities:",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch admin activities"})}};