"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists all P2P payment methods with pagination and optional filtering",operationId:"listP2PPaymentMethods",tags:["Admin","P2P","Payment Method"],parameters:constants_1.crudParameters,responses:{200:{description:"Paginated list of P2P payment methods",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("P2P Payment Methods"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_P2P",logTitle:"Get P2P Payment Methods",permission:"view.p2p.payment_method",demoMask:["items.user.email"]};exports.default=async e=>{const{query:t,user:s,ctx:r}=e;null==r||r.step("Fetching data");if(!(null==s?void 0:s.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.success("Operation completed successfully");return(0,query_1.getFiltered)({model:db_1.models.p2pPaymentMethod,query:t,sortField:t.sortField||"createdAt",where:{},includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email"],required:!1}]})};