"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get Monthly Platform Activity (Admin)",description:"Retrieves aggregated platform activity data for the current year, grouped by month. Returns data for all 12 months even if no activity exists for some months.",operationId:"getAdminP2PMonthlyPlatformActivity",tags:["Admin","Dashboard","P2P"],logModule:"ADMIN_P2P",logTitle:"Get P2P Activities",requiresAuth:!0,responses:{200:{description:"Monthly platform activity data retrieved successfully."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}},permission:"view.p2p.activity"};exports.default=async()=>{try{const e=(new Date).getFullYear(),t=new Date(e,0,1),r=new Date(e,11,31,23,59,59,999),[o]=await db_1.sequelize.query(`\n      SELECT DATE_FORMAT(createdAt, '%Y-%m-01') AS month,\n             COUNT(*) AS trades,\n             IFNULL(SUM(total)/1000, 0) AS volume,\n             IFNULL(SUM(\n               (SELECT amount FROM p2p_commissions \n                WHERE p2p_commissions.tradeId = p2p_trades.id \n                LIMIT 1)\n             )/1000, 0) AS revenue\n      FROM p2p_trades\n      WHERE createdAt BETWEEN '${t.toISOString()}' AND '${r.toISOString()}'\n      GROUP BY DATE_FORMAT(createdAt, '%Y-%m')\n      ORDER BY month ASC\n    `),a=[];for(let t=0;t<12;t++){const r=`${e}-${(t+1).toString().padStart(2,"0")}-01`;a.push({date:r,trades:0,volume:0,revenue:0})}o.forEach(e=>{const t=e.month.split("-")[1],r=parseInt(t,10)-1;r>=0&&r<12&&(a[r]={date:e.month,trades:Number(e.trades),volume:Number(e.volume),revenue:Number(e.revenue)})});return a}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};