"use strict";function formatActionTitle(e){return{ADMIN_UPDATE:"Offer Updated",ADMIN_ADMIN_UPDATE:"Offer Updated",ADMIN_APPROVE:"Offer Approved",ADMIN_REJECT:"Offer Rejected",ADMIN_FLAG:"Offer Flagged",ADMIN_DISABLE:"Offer Disabled",ADMIN_OFFER_APPROVED:"Offer Approved",ADMIN_OFFER_REJECTED:"Offer Rejected",ADMIN_OFFER_FLAGGED:"Offer Flagged",ADMIN_OFFER_DISABLED:"Offer Disabled",ADMIN_OFFER_UPDATED:"Offer Updated",ADMIN_PAYMENT_METHOD:"Payment Method Updated",ADMIN_DISPUTE_UPDATE:"Dispute Updated",OFFER_APPROVED:"Offer Approved",OFFER_REJECTED:"Offer Rejected",OFFER_FLAGGED:"Offer Flagged",OFFER_DISABLED:"Offer Disabled",OFFER_CREATED:"Offer Created",OFFER_UPDATED:"Offer Updated",TRADE_STARTED:"Trade Started",TRADE_COMPLETED:"Trade Completed",TRADE_CANCELLED:"Trade Cancelled",TRADE_DISPUTED:"Trade Disputed"}[e]||e.replace(/_/g," ").replace(/ADMIN /g,"").toLowerCase().replace(/\b\w/g,e=>e.toUpperCase())}function formatDescription(e,t,r){try{const i="string"==typeof e?JSON.parse(e):e,a=r||i.updatedBy||i.approvedBy||i.rejectedBy||i.flaggedBy||i.disabledBy||i.adminName||null,s=e=>a&&"undefined undefined"!==a&&a.trim()?`${e} by ${a}`:e;if(t.includes("APPROVE"))return s("Offer was approved");if(t.includes("REJECT")){return s("Offer was rejected"+(i.reason?`: ${i.reason}`:""))}if(t.includes("FLAG")){return s("Offer was flagged for review"+(i.reason?`: ${i.reason}`:""))}if(t.includes("DISABLE")){return s("Offer was disabled"+(i.reason?`: ${i.reason}`:""))}if(t.includes("UPDATE")){const e=[];i.currency&&e.push(`currency: ${i.currency}`);i.price&&e.push(`price: ${i.price}`);i.minAmount&&e.push(`min: ${i.minAmount}`);i.maxAmount&&e.push(`max: ${i.maxAmount}`);return e.length>0?s(`Updated ${e.join(", ")}`):s("Offer details were updated")}if(t.includes("PAYMENT_METHOD")){const e=i.action||"updated";return s(`Payment method${i.name?` "${i.name}"`:""} ${e}`)}if("TRADE_STARTED"===t)return`New trade started for ${i.amount||"N/A"} ${i.currency||""}`;if("TRADE_COMPLETED"===t)return`Trade completed successfully for ${i.amount||"N/A"} ${i.currency||""}`;if("TRADE_DISPUTED"===t)return`Trade disputed: ${i.reason||"No reason provided"}`;if(t.includes("DISPUTE")){return s(`Dispute updated${i.status?` to ${i.status}`:""}`)}const d=[];i.amount&&d.push(`Amount: ${i.amount}`);i.currency&&d.push(`Currency: ${i.currency}`);i.status&&d.push(`Status: ${i.status}`);return d.length>0?d.join(", "):"Activity recorded"}catch(t){return e||"Activity recorded"}}function getPriority(e){return e.includes("DISPUTE")||e.includes("FLAG")?"high":e.includes("APPROVE")||e.includes("REJECT")?"medium":"low"}function getActivityIcon(e){return e.includes("TRADE")?"trade":e.includes("DISPUTE")?"dispute":e.includes("PAYMENT")?"payment":e.includes("USER")?"user":"system"}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get All P2P Activity (Admin)",description:"Retrieves all P2P activity logs with pagination and filtering options for the admin dashboard.",operationId:"getAllAdminP2PActivity",tags:["Admin","Dashboard","Activity","P2P"],logModule:"ADMIN_P2P",logTitle:"Get All P2P Activities",requiresAuth:!0,parameters:[{index:0,name:"page",in:"query",description:"Page number for pagination",required:!1,schema:{type:"integer",default:1}},{index:1,name:"limit",in:"query",description:"Number of items per page",required:!1,schema:{type:"integer",default:20,maximum:100}},{index:2,name:"type",in:"query",description:"Filter by activity type",required:!1,schema:{type:"string"}},{index:3,name:"userId",in:"query",description:"Filter by user ID",required:!1,schema:{type:"string"}},{index:4,name:"startDate",in:"query",description:"Filter activities from this date",required:!1,schema:{type:"string",format:"date-time"}},{index:5,name:"endDate",in:"query",description:"Filter activities until this date",required:!1,schema:{type:"string",format:"date-time"}}],responses:{200:{description:"Activity logs retrieved successfully."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}},permission:"view.p2p.activity",demoMask:["activities.user.email"]};exports.default=async e=>{try{const{query:t,ctx:r}=e;null==r||r.step("Fetching all P2P activity logs");const i=parseInt(t.page)||1,a=Math.min(parseInt(t.limit)||20,100),s=(i-1)*a,d={};t.type&&(d.type=t.type);t.userId&&(d.userId=t.userId);if(t.startDate||t.endDate){d.createdAt={};t.startDate&&(d.createdAt[db_1.models.Sequelize.Op.gte]=new Date(t.startDate));t.endDate&&(d.createdAt[db_1.models.Sequelize.Op.lte]=new Date(t.endDate))}const n=await db_1.models.p2pActivityLog.count({where:d}),u=(await db_1.models.p2pActivityLog.findAll({where:d,order:[["createdAt","DESC"]],limit:a,offset:s,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]})).map(e=>{const t=e.get({plain:!0}),r=t.user?`${t.user.firstName} ${t.user.lastName}`:void 0;return{id:t.id,type:getActivityIcon(t.type),title:formatActionTitle(t.type),description:formatDescription(t.details,t.type,r),createdAt:new Date(t.createdAt).toLocaleString(),status:"active",priority:getPriority(t.type),relatedEntity:t.relatedEntity,relatedEntityId:t.relatedEntityId,user:t.user?{id:t.user.id,firstName:t.user.firstName||"Unknown",lastName:t.user.lastName||"User",email:t.user.email||"",avatar:t.user.avatar||"/placeholder.svg"}:{id:t.userId,firstName:"System",lastName:"User",email:"",avatar:"/placeholder.svg"}}}),o=Math.ceil(n/a),c=i<o,l=i>1;null==r||r.success("P2P activity logs retrieved successfully");return{activities:u,pagination:{page:i,limit:a,totalCount:n,totalPages:o,hasNextPage:c,hasPrevPage:l}}}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};