"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Get template options",operationId:"getMailwizardTemplateOptions",tags:["Admin","Mailwizard","Templates"],description:"Retrieves a simplified list of all Mailwizard templates (ID and name only) for use in dropdown selections and UI components. This endpoint is optimized for quick loading in form selects.",requiresAuth:!0,logModule:"ADMIN_MAIL",logTitle:"Get Mail Template Options",responses:{200:{description:"Mailwizard template options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Template ID"},name:{type:"string",description:"Template name"}},required:["id","name"]}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Mailwizard Template"),500:errors_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:t}=e;null==t||t.step("Validate user authentication");if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{const e=(await db_1.models.mailwizardTemplate.findAll()).map(e=>({id:e.id,name:e.name}));null==t||t.success("Get Mail Template Options retrieved successfully");return e}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching mailwizard templates")}};