"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Admin Stats",description:"Retrieves aggregated statistics for the ICO admin dashboard.",operationId:"getAdminStats",tags:["ICO","Admin","Stats"],requiresAuth:!0,logModule:"ADMIN_ICO",logTitle:"Get ICO Stats",responses:{200:{description:"Admin stats retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{totalOfferings:{type:"number"},pendingOfferings:{type:"number"},activeOfferings:{type:"number"},completedOfferings:{type:"number"},rejectedOfferings:{type:"number"},totalRaised:{type:"number"},offeringGrowth:{type:"number"},raiseGrowth:{type:"number"},successRate:{type:"number"},successRateGrowth:{type:"number"},recentActivity:{type:"array",items:{type:"object",properties:{id:{type:"string"},type:{type:"string"},offeringId:{type:"string"},offeringName:{type:"string"},admin:{type:"object",properties:{id:{type:"string"},name:{type:"string"},avatar:{type:"string"}}},timestamp:{type:"string",format:"date-time"}}}}}}}}},401:{description:"Unauthorized – Admin privileges required."},500:{description:"Internal Server Error"}},permission:"access.ico.stat"};exports.default=async e=>{const{user:t,ctx:r}=e;null==r||r.step("Validate user authentication");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: Admin privileges required."});const i=new Date,s=new Date(i.getFullYear(),i.getMonth(),1),n=new Date(i.getFullYear(),i.getMonth()-1,1),a=new Date(i.getFullYear(),i.getMonth(),0),[o,l,u,d,E,f]=await Promise.all([db_1.models.icoTokenOffering.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("*")),"totalOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'PENDING' THEN 1 ELSE 0 END")),"pendingOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN 1 ELSE 0 END")),"activeOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'SUCCESS' THEN 1 ELSE 0 END")),"completedOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'REJECTED' THEN 1 ELSE 0 END")),"rejectedOfferings"]],raw:!0}),db_1.models.icoTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("price * amount")),"totalReleased"]],where:{status:{[sequelize_1.Op.not]:["REJECTED"]}},raw:!0}),db_1.models.icoTokenOffering.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${s.toISOString()}' THEN 1 ELSE 0 END`)),"currentOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${a.toISOString()}' THEN 1 ELSE 0 END`)),"previousOfferings"]],raw:!0}),db_1.models.icoTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${s.toISOString()}' AND status NOT IN ('REJECTED') THEN price * amount ELSE 0 END`)),"currentInvested"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${a.toISOString()}' AND status NOT IN ('REJECTED') THEN price * amount ELSE 0 END`)),"previousInvested"]],raw:!0}),db_1.models.icoTokenOffering.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${s.toISOString()}' THEN 1 ELSE 0 END`)),"currentTotal"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${s.toISOString()}' AND status = 'ACTIVE' THEN 1 ELSE 0 END`)),"currentActive"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${a.toISOString()}' THEN 1 ELSE 0 END`)),"previousTotal"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${a.toISOString()}' AND status = 'ACTIVE' THEN 1 ELSE 0 END`)),"previousActive"]],raw:!0}),db_1.models.icoAdminActivity.findAll({include:[{model:db_1.models.user,as:"admin",attributes:["firstName","lastName","avatar"]}],order:[["createdAt","DESC"]],limit:5,raw:!0})]),c=parseInt(o.totalOfferings,10)||0,p=parseInt(o.pendingOfferings,10)||0,g=parseInt(o.activeOfferings,10)||0,S=parseInt(o.completedOfferings,10)||0,m=parseInt(o.rejectedOfferings,10)||0,N=parseFloat(l.totalReleased)||0,O=parseInt(u.currentOfferings,10)||0,A=parseInt(u.previousOfferings,10)||0,I=A>0?Math.round((O-A)/A*100):0,_=parseFloat(d.currentInvested)||0,q=parseFloat(d.previousInvested)||0,v=q>0?Math.round((_-q)/q*100):0,T=c>0?Math.round(g/c*100):0,y=parseInt(E.currentTotal,10)||0,z=parseInt(E.currentActive,10)||0,b=parseInt(E.previousTotal,10)||0,D=parseInt(E.previousActive,10)||0,C=y>0?Math.round(z/y*100):0,H=b>0?Math.round(D/b*100):0,M=H?C-H:0,h=f.map(e=>({id:e.id,type:e.type,offeringId:e.offeringId,offeringName:e.offeringName,adminId:e.adminId,admin:{name:`${e["admin.firstName"]} ${e["admin.lastName"]}`,avatar:e["admin.avatar"]},timestamp:e.createdAt}));null==r||r.success("Get ICO Stats retrieved successfully");return{totalOfferings:c,pendingOfferings:p,activeOfferings:g,completedOfferings:S,rejectedOfferings:m,totalRaised:N,offeringGrowth:I,raiseGrowth:v,successRate:T,successRateGrowth:M,recentActivity:h}};