"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Update ICO Investment Limits",description:"Updates the ICO investment limit settings with validation. Ensures min/max relationships are valid and soft cap percentage is within 0-100 range. Changes are logged in audit trail.",operationId:"updateIcoInvestmentLimits",tags:["Admin","ICO","Settings"],requiresAuth:!0,requiresAdmin:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{minInvestment:{type:"number",minimum:0,description:"Minimum investment amount"},maxInvestment:{type:"number",minimum:0,description:"Maximum investment amount"},maxPerUser:{type:"number",minimum:0,description:"Maximum investment per user"},softCapPercentage:{type:"number",minimum:0,maximum:100,description:"Soft cap percentage"},refundGracePeriod:{type:"number",minimum:0,description:"Refund grace period in days"},vestingEnabled:{type:"boolean",description:"Enable token vesting"},defaultVestingMonths:{type:"number",minimum:0,description:"Default vesting period in months"}}}}}},responses:{200:{description:"ICO limits updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse},logModule:"ADMIN_ICO",logTitle:"Update ICO limits"};exports.default=async e=>{var t,i;const{user:n,body:r,ctx:s}=e;if(!(null==n?void 0:n.id)){null==s||s.fail("Authentication required");throw(0,error_1.createError)({statusCode:401,message:"Authentication required"})}null==s||s.step("Checking admin privileges");const a=await db_1.models.user.findByPk(n.id,{include:[{model:db_1.models.role,as:"role"}]});if(!a||"admin"!==(null===(t=a.role)||void 0===t?void 0:t.name)&&"super_admin"!==(null===(i=a.role)||void 0===i?void 0:i.name)){null==s||s.fail("Admin privileges required");throw(0,error_1.createError)({statusCode:403,message:"Admin privileges required"})}const{minInvestment:o,maxInvestment:l,maxPerUser:u,softCapPercentage:d,refundGracePeriod:m,vestingEnabled:c,defaultVestingMonths:p}=r;null==s||s.step("Validating limit values");if(void 0!==o&&o<0){null==s||s.fail("Invalid minimum investment");throw(0,error_1.createError)({statusCode:400,message:"Minimum investment cannot be negative"})}if(void 0!==l&&void 0!==o&&l<o){null==s||s.fail("Invalid max/min investment relationship");throw(0,error_1.createError)({statusCode:400,message:"Maximum investment must be greater than minimum investment"})}if(void 0!==d&&(d<0||d>100)){null==s||s.fail("Invalid soft cap percentage");throw(0,error_1.createError)({statusCode:400,message:"Soft cap percentage must be between 0 and 100"})}null==s||s.step("Starting database transaction");const v=await db_1.sequelize.transaction();try{null==s||s.step("Updating limit settings");const e=[{key:"icoMinInvestment",value:null==o?void 0:o.toString()},{key:"icoMaxInvestment",value:null==l?void 0:l.toString()},{key:"icoMaxPerUser",value:null==u?void 0:u.toString()},{key:"icoSoftCapPercentage",value:null==d?void 0:d.toString()},{key:"icoRefundGracePeriod",value:null==m?void 0:m.toString()},{key:"icoVestingEnabled",value:null==c?void 0:c.toString()},{key:"icoDefaultVestingMonths",value:null==p?void 0:p.toString()}].filter(e=>void 0!==e.value);for(const t of e)await db_1.models.settings.upsert({key:t.key,value:t.value},{transaction:v});null==s||s.step("Creating audit log");await db_1.models.icoAdminActivity.create({type:"SETTINGS_UPDATED",offeringId:null,offeringName:"ICO Limits",adminId:n.id,details:JSON.stringify({updates:e.reduce((e,t)=>{e[t.key]=t.value;return e},{})})},{transaction:v});await v.commit();null==s||s.success("ICO limits updated successfully");return{message:"ICO limits updated successfully"}}catch(e){await v.rollback();null==s||s.fail("Transaction failed");throw e}};