"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create ICO Launch Plan",description:"Creates a new ICO launch plan with pricing and feature configuration. Launch plans define what features and limits token offering creators get based on their subscription tier.",operationId:"createIcoLaunchPlan",tags:["Admin","ICO","Settings"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"The plan name"},description:{type:"string",description:"Plan description"},price:{type:"number",description:"Plan price"},currency:{type:"string",description:"Currency code (e.g., USD)"},walletType:{type:"string",description:"Wallet type for the plan"},features:{type:"object",description:"Plan features in JSON format"},recommended:{type:"boolean",description:"If this plan is recommended"},status:{type:"boolean",description:"Plan status. Defaults to true if not provided"},sortOrder:{type:"number",description:"Sort order of the plan"}},required:["name","description","price","currency","walletType","features"]}}}},responses:{200:{description:"Launch plan created successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"edit.ico.settings",logModule:"ADMIN_ICO",logTitle:"Create launch plan"};exports.default=async e=>{const{user:r,body:t,ctx:s}=e;null==s||s.step("Validating user permissions");if(!(null==r?void 0:r.id)){null==s||s.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{name:n,description:i,price:a,currency:o,walletType:c,features:p,recommended:l,status:u,sortOrder:d}=t;null==s||s.step("Validating launch plan data");if(!(n&&i&&void 0!==a&&o&&c&&p)){null==s||s.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: name, description, price, currency, walletType, features"})}const m=void 0===u||u;null==s||s.step("Creating launch plan");await db_1.models.icoLaunchPlan.create({name:n,description:i,price:a,currency:o,walletType:c,features:p,recommended:l||!1,status:m,sortOrder:d||0});null==s||s.success("Launch plan created successfully");return{message:"Launch plan created successfully."}};