"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List ICO Blockchain Configurations",description:"Retrieves all blockchain configurations available for ICO token offerings. Supports optional filtering by status to retrieve only active blockchains.",operationId:"getIcoBlockchains",tags:["Admin","ICO","Settings"],requiresAuth:!0,parameters:[{name:"status",in:"query",description:"Filter by status - set to 'true' to retrieve only active blockchains",required:!1,schema:{type:"string",enum:["true","false"]}}],responses:{200:{description:"Blockchain configurations retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid"},name:{type:"string",description:"Display name of the blockchain"},value:{type:"string",description:"Unique identifier value for the blockchain"},status:{type:"boolean",description:"Whether the blockchain is active"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"},deletedAt:{type:"string",format:"date-time",nullable:!0}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.ico.settings",logModule:"ADMIN_ICO",logTitle:"Get blockchain configurations"};exports.default=async e=>{const{user:t,query:i,ctx:r}=e;null==r||r.step("Validating user permissions");if(!(null==t?void 0:t.id)){null==r||r.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: Admin privileges required."})}null==r||r.step("Building query filters");const s="true"===(null==i?void 0:i.status)?{status:!0}:{};null==r||r.step("Fetching blockchain configurations");const o=await db_1.models.icoBlockchain.findAll({where:s});null==r||r.success(`Retrieved ${o.length} blockchain configurations`);return o};