"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists ICO offerings with computed currentRaised",operationId:"listIcoTransactions",tags:["User","Ico","Transaction"],parameters:constants_1.crudParameters,responses:{401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transactions"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_ICO",logTitle:"Get ICO Offers",permission:"view.ico.offer"};exports.default=async e=>{const{user:r,query:t,ctx:s}=e;null==s||s.step("Validate user authentication");if(!r)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetch ICO offerings with computed metrics");const o=await(0,query_1.getFiltered)({model:db_1.models.icoTokenOffering,query:t,sortField:t.sortField||"createdAt",compute:[[(0,sequelize_1.literal)("(\n          SELECT COALESCE(SUM(t.price * t.amount), 0)\n          FROM ico_transaction t\n          WHERE t.offeringId = icoTokenOffering.id\n            AND t.status IN ('PENDING', 'RELEASED')\n        )"),"currentRaised"]]});null==s||s.success("Get ICO Offers retrieved successfully");return o};