"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications"),console_1=require("@b/utils/console"),offeringCreationSchema={type:"object",properties:{userId:{type:"string",format:"uuid"},name:{type:"string"},symbol:{type:"string"},icon:{type:"string"},tokenType:{type:"string"},blockchain:{type:"string"},totalSupply:{type:"number"},description:{type:"string"},tokenDetails:{type:"object"},teamMembers:{type:"array"},roadmap:{type:"array"},website:{type:"string"},targetAmount:{type:"number"},startDate:{type:"string"},phases:{type:"array"},selectedPlan:{type:"string"},status:{type:"string"},submittedBy:{type:"string"},submittedAt:{type:"string"}},required:["userId","name","symbol","tokenType","blockchain","totalSupply","selectedPlan"]};exports.metadata={summary:"Admin: Create ICO Offering (No Payment)",description:"Creates a new ICO offering as admin for any user without charging wallet.",operationId:"adminCreateIcoOffering",tags:["ICO","Admin"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:offeringCreationSchema}}},responses:{200:{description:"ICO offering created successfully."},401:{description:"Unauthorized – Admin privileges required."},400:{description:"Bad Request"},500:{description:"Internal Server Error"}},permission:"create.ico.offer",logModule:"ADMIN_ICO",logTitle:"Admin Create ICO Offering"};exports.default=async e=>{var t,r,a,o,i;const{user:s,body:n,ctx:l}=e;if(!s)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{userId:d,name:c,symbol:u,icon:m,tokenType:p,blockchain:f,totalSupply:g,description:y,tokenDetails:b,teamMembers:h,roadmap:w,website:I,targetAmount:C,startDate:_,phases:k,selectedPlan:O,status:v="PENDING",submittedAt:D=(new Date).toISOString()}=n;null==l||l.step("Validating launch plan");const E=await db_1.models.icoLaunchPlan.findOne({where:{id:O}});if(!E)throw(0,error_1.createError)({statusCode:400,message:"Invalid launch plan selected."});null==l||l.step("Validating token type");if(!p)throw(0,error_1.createError)({statusCode:400,message:"Token type is required."});if(!/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(p))throw(0,error_1.createError)({statusCode:400,message:"Invalid token type ID format. Please provide a valid UUID."});const A=await db_1.models.icoTokenType.findOne({where:{id:p}});if(!A)throw(0,error_1.createError)({statusCode:400,message:`Token type with ID ${p} not found.`});null==l||l.step("Parsing and validating plan features");let T;try{T=JSON.parse(E.features)}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Failed to parse launch plan features."})}if(h&&h.length>T.maxTeamMembers)throw(0,error_1.createError)({statusCode:400,message:`Maximum allowed team members is ${T.maxTeamMembers}.`});if(w&&w.length>T.maxRoadmapItems)throw(0,error_1.createError)({statusCode:400,message:`Maximum allowed roadmap items is ${T.maxRoadmapItems}.`});if(k&&k.length>T.maxOfferingPhases)throw(0,error_1.createError)({statusCode:400,message:`Maximum allowed offering phases is ${T.maxOfferingPhases}.`});null==l||l.step("Creating ICO offering with all details");const P=await db_1.sequelize.transaction();try{const e=new Date(_);let t=0;for(const e of k)t+=e.durationDays;const r=new Date(e);r.setDate(r.getDate()+t);const a=k.length>0?k[0].tokenPrice:0,o=await db_1.models.icoTokenOffering.create({userId:d,planId:E.id,typeId:A.id,name:c,icon:m,symbol:u.toUpperCase(),status:v.toUpperCase(),purchaseWalletCurrency:E.currency,purchaseWalletType:E.walletType,tokenPrice:a,targetAmount:C,startDate:e,endDate:r,participants:0,isPaused:!1,isFlagged:!1,submittedAt:D,website:I},{transaction:P});await db_1.models.icoTokenDetail.create({offeringId:o.id,tokenType:A.name,totalSupply:g,tokensForSale:g,salePercentage:0,blockchain:f,description:y,useOfFunds:b.useOfFunds,links:[{label:"whitepaper",url:b.whitepaper},{label:"github",url:b.github},{label:"twitter",url:b.twitter},{label:"telegram",url:b.telegram}]},{transaction:P});for(let e=0;e<k.length;e++){const t=k[e];await db_1.models.icoTokenOfferingPhase.create({offeringId:o.id,name:t.name,tokenPrice:t.tokenPrice,allocation:t.allocation,duration:t.durationDays,remaining:t.allocation,sequence:e},{transaction:P})}if(Array.isArray(h))for(const e of h)e.name&&e.role&&e.bio&&await db_1.models.icoTeamMember.create({offeringId:o.id,name:e.name,role:e.role,bio:e.bio,avatar:e.avatar,linkedin:e.linkedin,twitter:e.twitter,website:e.website,github:e.github},{transaction:P});if(Array.isArray(w))for(const e of w)e.title&&e.description&&e.date&&await db_1.models.icoRoadmapItem.create({offeringId:o.id,title:e.title,description:e.description,date:e.date,completed:e.completed||!1},{transaction:P});await P.commit();null==l||l.step("Sending notification to user");try{await(0,notifications_1.createNotification)({userId:d,relatedId:o.id,title:"Admin Created Offering",type:"system",message:`An ICO offering "${o.name}" has been created for you by the admin.`,details:"Check your dashboard for more details.",link:`/ico/creator/token/${o.id}`},l)}catch(e){console_1.logger.error("ADMIN_ICO_OFFER","Failed to notify user for admin-created offering",e)}null==l||l.success("ICO offering created successfully");return{message:"Offering created successfully.",offeringId:o.id}}catch(e){await P.rollback();console_1.logger.error("ADMIN_ICO_OFFER","ICO creation failed",e);if("SequelizeUniqueConstraintError"===e.name){const i=(null===(r=null===(t=e.errors)||void 0===t?void 0:t[0])||void 0===r?void 0:r.path)||"field",s=(null===(o=null===(a=e.errors)||void 0===a?void 0:a[0])||void 0===o?void 0:o.value)||"";let n="";n="icoTokenOfferingSymbolKey"===i||"symbol"===i?`Token symbol "${s}" is already in use. Please choose a different symbol.`:`The ${i} "${s}" is already in use.`;throw(0,error_1.createError)({statusCode:400,message:n})}if("SequelizeValidationError"===e.name||"SequelizeDatabaseError"===e.name){const t=(null===(i=e.errors)||void 0===i?void 0:i.map(e=>`${e.path}: ${e.message}`).join(", "))||e.message;throw(0,error_1.createError)({statusCode:400,message:`Validation Error: ${t}`})}throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};