"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get gateway dashboard statistics",description:"Retrieves comprehensive overview statistics for the payment gateway admin dashboard including merchant counts, payment statistics (volume, counts by status), refund data, pending payouts, and recent payment activity. Supports filtering by mode (LIVE/TEST).",operationId:"getGatewayStats",tags:["Admin","Gateway","Stats"],parameters:[{name:"mode",in:"query",description:"Filter payments by mode (LIVE or TEST)",schema:{type:"string",enum:["LIVE","TEST"]}}],responses:{200:{description:"Gateway dashboard statistics",content:{"application/json":{schema:{type:"object",properties:{mode:{type:"string",description:"Current mode (LIVE or TEST)"},merchants:{type:"object",properties:{total:{type:"number"},active:{type:"number"},pending:{type:"number"}}},payments:{type:"object",properties:{total:{type:"number"},completed:{type:"number"},pending:{type:"number"},failed:{type:"number"},refunded:{type:"number"},partiallyRefunded:{type:"number"},totalVolume:{type:"number",description:"Total payment volume"},totalRefunded:{type:"number",description:"Total refunded amount"},netVolume:{type:"number",description:"Net volume (total - refunded)"},totalFees:{type:"number",description:"Total fees collected"}}},payouts:{type:"object",properties:{pending:{type:"number",description:"Number of pending payouts"},pendingAmount:{type:"number",description:"Total pending payout amount"}}},recentPayments:{type:"array",items:{type:"object",description:"Recent payment with merchant and customer info"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"access.gateway.merchant",logModule:"ADMIN_GATEWAY",logTitle:"Get gateway statistics",demoMask:["recentPayments.customer.email"]};exports.default=async e=>{var t,a;const{query:n,ctx:s}=e,o=(null==n?void 0:n.mode)||"LIVE",r="TEST"===o;null==s||s.step(`Calculating gateway statistics (mode: ${o})`);null==s||s.step("Fetching merchant statistics");const[i,u,l]=await Promise.all([db_1.models.gatewayMerchant.count(),db_1.models.gatewayMerchant.count({where:{status:"ACTIVE"}}),db_1.models.gatewayMerchant.count({where:{status:"PENDING"}})]);null==s||s.step("Fetching payment statistics");const d={testMode:r},[m,c,p,y]=await Promise.all([db_1.models.gatewayPayment.count({where:d}),db_1.models.gatewayPayment.count({where:{...d,status:"COMPLETED"}}),db_1.models.gatewayPayment.count({where:{...d,status:"PENDING"}}),db_1.models.gatewayPayment.count({where:{...d,status:"FAILED"}})]);null==s||s.step("Calculating volume and refund statistics");const b=await db_1.models.gatewayPayment.findOne({where:{status:"COMPLETED",testMode:r},attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalVolume"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("feeAmount")),"totalFees"]],raw:!0}),w=await db_1.models.gatewayRefund.findOne({where:{status:"COMPLETED"},attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("gatewayRefund.amount")),"totalRefunded"]],include:[{model:db_1.models.gatewayPayment,as:"payment",where:{testMode:r},attributes:[]}],raw:!0}),[g,h]=await Promise.all([db_1.models.gatewayPayment.count({where:{...d,status:"REFUNDED"}}),db_1.models.gatewayPayment.count({where:{...d,status:"PARTIALLY_REFUNDED"}})]);null==s||s.step("Fetching payout statistics");const f=await db_1.models.gatewayPayout.findAll({where:{status:"PENDING"},attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"amount"]],raw:!0});null==s||s.step("Fetching recent payments");const v=await db_1.models.gatewayPayment.findAll({where:{testMode:r},limit:10,order:[["createdAt","DESC"]],include:[{model:db_1.models.gatewayMerchant,as:"merchant",attributes:["id","name","logo"]},{model:db_1.models.user,as:"customer",attributes:["firstName","lastName","email","avatar"]}]}),_=parseFloat(null==b?void 0:b.totalVolume)||0,E=parseFloat(null==b?void 0:b.totalFees)||0,P=parseFloat(null==w?void 0:w.totalRefunded)||0,T=_-P;null==s||s.success(`Gateway statistics calculated: ${m} payments, ${i} merchants`);return{mode:o,merchants:{total:i,active:u,pending:l},payments:{total:m,completed:c,pending:p,failed:y,refunded:g,partiallyRefunded:h,totalVolume:_,totalRefunded:P,netVolume:T,totalFees:E},payouts:{pending:parseInt(null===(t=null==f?void 0:f[0])||void 0===t?void 0:t.count)||0,pendingAmount:parseFloat(null===(a=null==f?void 0:f[0])||void 0===a?void 0:a.amount)||0},recentPayments:v.map(e=>{var t,a,n;return{id:e.paymentIntentId,amount:e.amount,currency:e.currency,walletType:e.walletType,status:e.status,feeAmount:e.feeAmount,description:e.description,merchantId:null===(t=e.merchant)||void 0===t?void 0:t.id,merchantName:(null===(a=e.merchant)||void 0===a?void 0:a.name)||"Unknown",merchantLogo:null===(n=e.merchant)||void 0===n?void 0:n.logo,customer:e.customer?{name:`${e.customer.firstName||""} ${e.customer.lastName||""}`.trim()||e.customer.email,email:e.customer.email,avatar:e.customer.avatar}:null,createdAt:e.createdAt}})}};