"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),cache_1=require("@b/utils/cache"),errors_1=require("@b/utils/schema/errors"),GATEWAY_SETTINGS_KEYS=["gatewayEnabled","gatewayTestMode","gatewayFeePercentage","gatewayFeeFixed","gatewayMinPaymentAmount","gatewayMaxPaymentAmount","gatewayDailyLimit","gatewayMonthlyLimit","gatewayMinPayoutAmount","gatewayPayoutSchedule","gatewayAllowedWalletTypes","gatewayRequireKyc","gatewayAutoApproveVerified","gatewayPaymentExpirationMinutes","gatewayWebhookRetryAttempts","gatewayWebhookRetryDelaySeconds"];exports.metadata={summary:"Update gateway settings",description:"Updates payment gateway configuration settings. Only gateway-prefixed settings from the allowed list can be updated. Automatically clears cache after update to ensure new settings take effect immediately.",operationId:"updateGatewaySettings",tags:["Admin","Gateway","Settings"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",additionalProperties:!0,description:"Settings to update (key-value pairs, only gateway-prefixed keys allowed)"}}}},responses:{200:{description:"Settings updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},updatedKeys:{type:"array",items:{type:"string"},description:"List of setting keys that were updated"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.gateway.settings",logModule:"ADMIN_GATEWAY",logTitle:"Update gateway settings"};exports.default=async e=>{const{body:t,ctx:a}=e;null==a||a.step("Validating and processing settings");const s=[];for(const[e,i]of Object.entries(t)){if(!e.startsWith("gateway")||!GATEWAY_SETTINGS_KEYS.includes(e))continue;null==a||a.step(`Updating setting: ${e}`);const t="object"==typeof i?JSON.stringify(i):String(i),n=await db_1.models.settings.findOne({where:{key:e}});n?await n.update({value:t}):await db_1.models.settings.create({key:e,value:t});s.push(e)}null==a||a.step("Clearing cache");const i=cache_1.CacheManager.getInstance();await i.clearCache();null==a||a.success(`Updated ${s.length} gateway settings`);return{message:"Settings updated successfully",updatedKeys:s}};