"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),errors_1=require("@b/utils/schema/errors"),GATEWAY_SETTINGS_KEYS=["gatewayEnabled","gatewayTestMode","gatewayFeePercentage","gatewayFeeFixed","gatewayMinPaymentAmount","gatewayMaxPaymentAmount","gatewayDailyLimit","gatewayMonthlyLimit","gatewayMinPayoutAmount","gatewayPayoutSchedule","gatewayAllowedWalletTypes","gatewayRequireKyc","gatewayAutoApproveVerified","gatewayPaymentExpirationMinutes","gatewayWebhookRetryAttempts","gatewayWebhookRetryDelaySeconds"];exports.metadata={summary:"Get gateway settings",description:"Retrieves all payment gateway configuration settings including fee structure, payment limits, payout settings, allowed wallet types, security options, and webhook configuration.",operationId:"getGatewaySettings",tags:["Admin","Gateway","Settings"],responses:{200:{description:"Gateway settings as key-value pairs",content:{"application/json":{schema:{type:"object",additionalProperties:!0,description:"Settings object with parsed JSON values"}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.gateway.settings",logModule:"ADMIN_GATEWAY",logTitle:"Get gateway settings"};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching gateway settings");const a=await db_1.models.settings.findAll({where:{key:GATEWAY_SETTINGS_KEYS}});null==t||t.step("Parsing settings values");const s={};for(const e of a){let t=e.value;if(e.value)try{t=JSON.parse(e.value)}catch(e){}s[e.key]=t}null==t||t.success(`Retrieved ${a.length} gateway settings`);return s};