"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants");exports.metadata={summary:"List gateway payments",description:"Retrieves a paginated list of all gateway payments with filtering and sorting capabilities. Supports filtering by mode (LIVE/TEST) and includes merchant and customer information for each payment.",operationId:"listGatewayPayments",tags:["Admin","Gateway","Payment"],parameters:[...constants_1.crudParameters,{name:"mode",in:"query",description:"Filter by mode (LIVE or TEST)",schema:{type:"string",enum:["LIVE","TEST"]}}],responses:{200:{description:"Paginated list of payments",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",description:"Payment with merchant and customer information"}},pagination:{type:"object",properties:{total:{type:"number"},page:{type:"number"},perPage:{type:"number"}}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.gateway.payment",demoMask:["items.customer.email","items.merchant.email"],logModule:"ADMIN_GATEWAY",logTitle:"List gateway payments"};exports.default=async e=>{var t;const{query:a,ctx:s}=e,r=null==a?void 0:a.mode;null==s||s.step("Fetching payments list"+(r?` (mode: ${r})`:""));const i={};r&&(i.testMode="TEST"===r);const n=await(0,query_1.getFiltered)({model:db_1.models.gatewayPayment,query:a,where:i,sortField:a.sortField||"createdAt",includeModels:[{model:db_1.models.gatewayMerchant,as:"merchant",attributes:["id","name","slug","email"]},{model:db_1.models.user,as:"customer",attributes:["id","firstName","lastName","email"]}]});null==s||s.success(`Retrieved ${(null===(t=n.items)||void 0===t?void 0:t.length)||0} payments`);return n};