"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Creates a new futures market",operationId:"storeFuturesMarket",tags:["Admin","Futures","Market"],description:"Creates a new futures trading market by pairing two active ecosystem tokens. Validates that both tokens exist and are active, and ensures the market pair doesn't already exist.",requestBody:{required:!0,content:{"application/json":{schema:utils_1.FuturesMarketUpdateSchema}}},responses:{200:{description:"Futures market created successfully",content:{"application/json":{schema:{type:"object",properties:utils_1.baseFuturesMarketSchema}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Currency or Pair Token"),409:(0,errors_1.conflictResponse)("Futures Market"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"create.futures.market",logModule:"ADMIN_FUTURES",logTitle:"Create futures market"};exports.default=async e=>{const{body:r,ctx:t}=e,{currency:s,pair:a,isTrending:n,isHot:o,metadata:u}=r;null==t||t.step("Validating currency token");const i=await db_1.models.ecosystemToken.findOne({where:{id:s,status:!0}});if(!i){null==t||t.fail("Currency token not found or inactive");throw(0,error_1.createError)(404,"Currency token not found or inactive")}null==t||t.step("Validating pair token");const c=await db_1.models.ecosystemToken.findOne({where:{id:a,status:!0}});if(!c){null==t||t.fail("Pair token not found or inactive");throw(0,error_1.createError)(404,"Pair token not found or inactive")}null==t||t.step("Checking for existing market");if(await db_1.models.futuresMarket.findOne({where:{currency:i.currency,pair:c.currency}})){null==t||t.fail("Futures market already exists");throw(0,error_1.createError)(409,"Futures market with the given currency and pair already exists.")}try{null==t||t.step("Creating futures market");const e=await(0,query_1.storeRecord)({model:"futuresMarket",data:{currency:i.currency,pair:c.currency,isTrending:n,isHot:o,metadata:u,status:!0}});null==t||t.success("Futures market created successfully");return e}catch(e){if("SequelizeUniqueConstraintError"===e.name){null==t||t.fail("Unique constraint violation");throw(0,error_1.createError)(409,"Futures market already exists.")}null==t||t.fail(`Failed to create futures market: ${e.message}`);throw e}};