"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk deletes Forex signals",description:"Deletes multiple Forex trading signal configurations by their IDs. This will remove signal references from associated accounts.",operationId:"bulkDeleteForexSignals",tags:["Admin","Forex","Signal"],parameters:(0,query_1.commonBulkDeleteParams)("Forex Signals"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of Forex signal IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("Forex Signals"),requiresAuth:!0,permission:"delete.forex.signal",logModule:"ADMIN_FOREX",logTitle:"Bulk delete forex signals"};exports.default=async e=>{const{body:s,query:r,ctx:t}=e,{ids:l}=s;null==t||t.step(`Validating ${l.length} IDs`);null==t||t.step(`Deleting ${l.length} records`);const o=await(0,query_1.handleBulkDelete)({model:"forexSignal",ids:l,query:r});null==t||t.success(`Successfully deleted ${l.length} records`);return o};