"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk updates Forex investment statuses",description:"Updates the status of multiple Forex investments at once. Valid statuses are ACTIVE, COMPLETED, CANCELLED, or REJECTED.",operationId:"bulkUpdateForexInvestmentStatus",tags:["Admin","Forex","Investment"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of forex investment IDs to update",items:{type:"string"}},status:{type:"string",enum:["ACTIVE","COMPLETED","CANCELLED","REJECTED"],description:"New status to apply to the forex investments"}},required:["ids","status"]}}}},responses:(0,query_1.updateRecordResponses)("Forex Investment"),requiresAuth:!0,permission:"edit.forex.investment",logModule:"ADMIN_FOREX",logTitle:"Bulk update forex investment status"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:n,status:r}=t;null==s||s.step(`Validating ${n.length} forex investment IDs`);null==s||s.step(`Updating status to ${r} for ${n.length} forex investments`);const o=await(0,query_1.updateStatus)("forexInvestment",n,r);null==s||s.success(`Successfully updated status for ${n.length} forex investments`);return o};