"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),cron_1=require("@b/api/(ext)/forex/utils/cron"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console");exports.metadata={summary:"Recovers a failed Forex investment",description:"Manually retries processing of a failed Forex investment.",operationId:"recoverForexInvestment",tags:["Admin","Forex","Investment"],requiresAuth:!0,permission:["edit.forex.investment"],logModule:"ADMIN_FOREX",logTitle:"Recover forex investment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{investmentId:{type:"string",description:"ID of the investment to recover"}},required:["investmentId"]}}}},responses:{200:{description:"Investment recovery initiated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},investment:{type:"object",properties:{id:{type:"string"},status:{type:"string"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Investment"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:r,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{investmentId:o}=r;try{null==s||s.step(`Validating forex investment ${o}`);const e=await db_1.models.forexInvestment.findOne({where:{id:o,status:"CANCELLED"},include:[{model:db_1.models.forexPlan,as:"plan"},{model:db_1.models.forexDuration,as:"duration"}]});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Investment not found or not in CANCELLED status"});null==s||s.step("Resetting investment status to ACTIVE");await e.update({status:"ACTIVE",metadata:null});try{null==s||s.step("Processing investment");await(0,cron_1.processForexInvestment)(e,0,s);null==s||s.success("Investment recovery initiated successfully");return{message:"Investment recovery initiated successfully",investment:{id:e.id,status:e.status}}}catch(e){null==s||s.fail("Failed to process investment");throw(0,error_1.createError)({statusCode:500,message:"Failed to process investment. It will be retried automatically."})}}catch(e){if(e.statusCode)throw e;console_1.logger.error("FOREX","Error recovering forex investment",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error"})}};