"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Gets Forex duration options",description:"Retrieves all available Forex durations formatted as selectable options with ID and display name (e.g., '1 HOUR', '7 DAY'). Useful for dropdown selections in forms.",operationId:"getForexDurationOptions",tags:["Admin","Forex","Duration"],requiresAuth:!0,logModule:"ADMIN_FOREX",logTitle:"Get Forex Duration Options",responses:{200:{description:"Forex durations retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("ForexDuration"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{const e=await db_1.models.forexDuration.findAll();return e.map(e=>({id:e.id,name:`${e.duration} ${e.timeframe}`}))}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching forex durations")}};