"use strict";function getPagePaths(e,t=""){const r=fs_1.default.readdirSync(e,{withFileTypes:!0}),a=[];for(const s of r){const r=path_1.default.join(e,s.name);if(s.isDirectory()){if(s.name.startsWith("_")||s.name.startsWith(".")||"api"===s.name||"admin"===s.name||"auth"===s.name)continue;let e=s.name;e.startsWith("[")&&e.endsWith("]")&&"[locale]"===e&&(e="");const i=e?`${t}/${e}`:t;a.push(...getPagePaths(r,i))}else if("page.tsx"===s.name||"page.jsx"===s.name){const e=t||"/";a.push(e)}}return a}function transformToPageLinks(e){return e.filter(e=>!(e.includes("/admin")||e.includes("/auth")||e.includes("/api")||e.includes("/error")||e.includes("/_")||"/404"===e||"/500"===e)).map(e=>{const t=e.split("/").filter(Boolean),r=t[0]||"general";return{id:e,path:e,name:t.length>0?t.join(" > ").replace(/\[|\]/g,"").replace(/-/g," ").replace(/\b\w/g,e=>e.toUpperCase()):"Home",group:r.charAt(0).toUpperCase()+r.slice(1)}})}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get Available Page Links",description:"Automatically scans the Next.js app directory to retrieve a list of available page paths. Excludes admin, auth, utility, and error pages. Returns page paths with metadata for FAQ assignment.",operationId:"getFaqPageLinks",tags:["Admin","FAQ","Pages"],requiresAuth:!0,responses:{200:{description:"Page links retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Unique identifier (same as path)"},path:{type:"string",description:"Page path"},name:{type:"string",description:"User-friendly page name"},group:{type:"string",description:"Page group/section"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.faq",logModule:"ADMIN_FAQ",logTitle:"Get FAQ page links"};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const a="production"===process.env.NODE_ENV?path_1.default.join(process.cwd(),"frontend","app"):path_1.default.join(process.cwd(),"..","frontend","app");let s=[];try{null==r||r.step("Scanning page directories");s=getPagePaths(a)}catch(e){console.error("Error scanning pages directory:",e);null==r||r.fail("Failed to scan page directories");throw(0,error_1.createError)({statusCode:500,message:"Failed to retrieve page links"})}const i=transformToPageLinks(s),n=Array.from(new Set(i.map(e=>e.path))).map(e=>i.find(t=>t.path===e));null==r||r.success("Page links retrieved successfully");return n};